/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.ConvertBodyProcessor;
import org.apache.camel.processor.SendProcessor;

public class NavigateRouteTest
extends ContextTestSupport {
    private static int count;

    public void testNavigateRoute() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Navigate nav = ((Route)this.context.getRoutes().get(0)).navigate();
        this.navigateRoute((Navigate<Processor>)nav);
        NavigateRouteTest.assertEquals((String)"There should be 6 processors to navigate", (int)6, (int)count);
    }

    private void navigateRoute(Navigate<Processor> nav) {
        if (!nav.hasNext()) {
            return;
        }
        for (Processor child : nav.next()) {
            ++count;
            if (child instanceof SendProcessor) {
                SendProcessor send = (SendProcessor)child;
                NavigateRouteTest.assertEquals((String)"mock://result", (String)send.getDestination().getEndpointUri());
            }
            if (child instanceof ConvertBodyProcessor) {
                ConvertBodyProcessor convert = (ConvertBodyProcessor)child;
                NavigateRouteTest.assertEquals(String.class, (Object)convert.getType());
            }
            if (!(child instanceof Navigate)) continue;
            this.navigateRoute((Navigate<Processor>)((Navigate)child));
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").convertBodyTo(String.class)).split((Expression)this.body().tokenize(" ")).to("mock:result");
            }
        };
    }
}

