/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.builder.RouteBuilder;

public class NewProcessorAndServiceTest
extends ContextTestSupport {
    private MyProcessor myProcessor;

    public void testNewProcessorAndService() throws Exception {
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        NewProcessorAndServiceTest.assertEquals((String)"Bye World", (String)out);
        NewProcessorAndServiceTest.assertTrue((String)"MyProcessor should be started", (boolean)this.myProcessor.isStarted());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").process((Processor)(NewProcessorAndServiceTest.this.myProcessor = new MyProcessor()));
            }
        };
    }

    private static class MyProcessor
    implements Processor,
    Service {
        private boolean started;

        private MyProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getOut().setBody((Object)"Bye World");
        }

        public void start() throws Exception {
            this.started = true;
        }

        public void stop() throws Exception {
            this.started = false;
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

