/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class RecipientListDoNotStopOnExceptionTest
extends ContextTestSupport {
    public void testRecipientListDoNotStopOnException() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"direct:a,direct:b,direct:c");
            RecipientListDoNotStopOnExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            RecipientListDoNotStopOnExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            RecipientListDoNotStopOnExceptionTest.assertEquals((String)"Damn", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").recipientList((Expression)this.header("foo")).to("mock:result");
                this.from("direct:a").to("mock:a");
                ((RouteDefinition)this.from("direct:b").to("mock:b")).throwException((Exception)new IllegalArgumentException("Damn"));
                this.from("direct:c").to("mock:c");
            }
        };
    }
}

