/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.processor.DefaultErrorHandler;
import org.apache.camel.processor.Resequencer;
import org.apache.camel.processor.interceptor.DefaultChannel;
import org.apache.camel.processor.interceptor.StreamCaching;

public class ResequencerTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;

    public void testSendMessagesInWrongOrderButReceiveThemInCorrectOrder() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"Guillaume", "Hiram", "James", "Rob"});
        this.sendBodies("direct:start", "Rob", "Hiram", "Guillaume", "James");
        this.resultEndpoint.assertIsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected boolean useJmx() {
        return this.getName().equals("testBatchResequencerTypeWithJmx");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ResequenceDefinition)this.from("direct:start").resequence().body()).to("mock:result");
            }
        };
    }

    public void testBatchResequencerTypeWithJmx() throws Exception {
        this.testBatchResequencerTypeWithoutJmx();
    }

    public void testBatchResequencerTypeWithoutJmx() throws Exception {
        List<Route> list = ResequencerTest.getRouteList(this.createRouteBuilder());
        ResequencerTest.assertEquals((String)("Number of routes created: " + list), (int)1, (int)list.size());
        Route route = list.get(0);
        EventDrivenConsumerRoute consumerRoute = ResequencerTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
        DefaultChannel channel = ResequencerTest.assertIsInstanceOf(DefaultChannel.class, ResequencerTest.unwrapChannel(consumerRoute.getProcessor()));
        ResequencerTest.assertIsInstanceOf(DefaultErrorHandler.class, channel.getErrorHandler());
        ResequencerTest.assertFalse((String)"Should not have stream caching", (boolean)channel.hasInterceptorStrategy(StreamCaching.class));
        ResequencerTest.assertIsInstanceOf(Resequencer.class, channel.getNextProcessor());
    }
}

