/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class RouteMEPOptionalOutTest
extends ContextTestSupport {
    public void testHasOut() {
        Object out = this.template.requestBody("direct:start", (Object)"Hi");
        RouteMEPOptionalOutTest.assertEquals((Object)"Bye World", (Object)out);
    }

    public void testHasNotOutForInOptionalOut() {
        Object out = this.template.sendBody("direct:noout", ExchangePattern.InOptionalOut, (Object)"Hi");
        RouteMEPOptionalOutTest.assertEquals(null, (Object)out);
    }

    public void testHasNotOutForInOut() {
        Object out = this.template.sendBody("direct:noout", ExchangePattern.InOut, (Object)"Hi");
        RouteMEPOptionalOutTest.assertEquals(null, (Object)out);
    }

    public void testHasNotOutForInOnly() {
        Object out = this.template.sendBody("direct:noout", ExchangePattern.InOnly, (Object)"Hi");
        RouteMEPOptionalOutTest.assertEquals(null, (Object)out);
    }

    public void testInOnly() {
        Object out = this.template.sendBody("direct:inonly", ExchangePattern.InOnly, (Object)"Hi");
        RouteMEPOptionalOutTest.assertEquals(null, (Object)out);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").setExchangePattern(ExchangePattern.InOptionalOut)).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getOut().setBody((Object)"Bye World");
                    }
                });
                ((RouteDefinition)this.from("direct:noout").setExchangePattern(ExchangePattern.InOptionalOut)).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getIn().setBody((Object)"Hello World");
                    }
                });
                this.from("direct:inonly").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getIn().setBody((Object)"Hello World");
                    }
                });
            }
        };
    }
}

