/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.SimpleDataSet;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.util.StopWatch;

public class RoutePerformanceTest
extends ContextTestSupport {
    private int size = 250;
    private SimpleDataSet dataSet = new SimpleDataSet(this.size);
    private String uri = "mock:results";

    public void testPerformance() throws Exception {
        StopWatch watch = new StopWatch();
        MockEndpoint endpoint = this.getMockEndpoint(this.uri);
        endpoint.expectedMessageCount((int)this.dataSet.getSize());
        endpoint.expectedHeaderReceived("foo", (Object)123);
        MockEndpoint.assertIsSatisfied((CamelContext)this.context, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        this.log.info("RoutePerformanceTest: Sent: " + this.size + " Took: " + watch.taken() + " ms");
    }

    @Override
    protected boolean canRunOnThisPlatform() {
        String os = System.getProperty("os.name");
        return !os.toLowerCase(Locale.ENGLISH).contains("hp-ux");
    }

    @Override
    protected Context createJndiContext() throws Exception {
        HashMap<String, Integer> headers = new HashMap<String, Integer>();
        headers.put("foo", 123);
        this.dataSet.setDefaultHeaders(headers);
        Context context = super.createJndiContext();
        context.bind("foo", (Object)this.dataSet);
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("dataset:foo").to("direct:start");
                this.from("direct:start").to(new String[]{"log:a?level=OFF", "log:b?level=OFF", "direct:c"});
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:c").choice().when().header("foo")).to(new String[]{RoutePerformanceTest.this.uri, "dataset:foo"})).otherwise().to(new String[]{RoutePerformanceTest.this.uri, "dataset:foo"})).end();
            }
        };
    }
}

