/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.RouteStartupOrder;

public class RouteStartupOrderSuspendResumeTest
extends ContextTestSupport {
    public void testRouteStartupOrderSuspendResume() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.suspend();
        this.context.resume();
        DefaultCamelContext dcc = (DefaultCamelContext)this.context;
        List order = dcc.getRouteStartupOrder();
        RouteStartupOrderSuspendResumeTest.assertEquals((int)4, (int)order.size());
        RouteStartupOrderSuspendResumeTest.assertEquals((String)"direct://foo", (String)((RouteStartupOrder)order.get(0)).getRoute().getEndpoint().getEndpointUri());
        RouteStartupOrderSuspendResumeTest.assertEquals((String)"direct://start", (String)((RouteStartupOrder)order.get(1)).getRoute().getEndpoint().getEndpointUri());
        RouteStartupOrderSuspendResumeTest.assertEquals((String)"direct://baz", (String)((RouteStartupOrder)order.get(2)).getRoute().getEndpoint().getEndpointUri());
        RouteStartupOrderSuspendResumeTest.assertEquals((String)"direct://bar", (String)((RouteStartupOrder)order.get(3)).getRoute().getEndpoint().getEndpointUri());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("B").startupOrder(2).to("direct:foo");
                this.from("direct:foo").routeId("A").startupOrder(1).to("mock:result");
                this.from("direct:bar").routeId("D").startupOrder(9).to("direct:bar");
                this.from("direct:baz").routeId("C").startupOrder(5).to("mock:other");
            }
        };
    }
}

