/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.InputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class StreamCachingInOutTest
extends ContextTestSupport {
    private static final String TEST_FILE = "org/apache/camel/processor/simple.txt";

    public void testStreamCachingPerRoute() throws Exception {
        MockEndpoint c = this.getMockEndpoint("mock:c");
        c.expectedMessageCount(1);
        InputStream message = this.getTestFileStream();
        this.template.sendBody("direct:c", (Object)message);
        this.assertMockEndpointsSatisfied();
        StreamCachingInOutTest.assertEquals((String)((String)c.assertExchangeReceived(0).getIn().getBody(String.class)), (String)"James,Guillaume,Hiram,Rob,Roman");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:c").noStreamCaching().to("direct:d")).to("mock:c");
                this.from("direct:d").streamCaching().process((Processor)new TestProcessor());
            }
        };
    }

    private InputStream getTestFileStream() {
        InputStream answer = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(TEST_FILE);
        StreamCachingInOutTest.assertNotNull((String)"Should have found the file: org/apache/camel/processor/simple.txt on the classpath", (Object)answer);
        return answer;
    }

    private class TestProcessor
    implements Processor {
        private TestProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
            while (is.available() > 0) {
                is.read();
            }
            is.close();
        }
    }
}

