/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class StreamCachingPerRouteTest
extends ContextTestSupport {
    public void testStreamCachingPerRoute() throws Exception {
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedMessageCount(1);
        MockEndpoint b = this.getMockEndpoint("mock:b");
        b.expectedMessageCount(1);
        MockEndpoint c = this.getMockEndpoint("mock:c");
        c.expectedMessageCount(1);
        new StreamSource(new StringReader("A"));
        this.template.sendBody("direct:a", (Object)new StreamSource(new StringReader("A")));
        StreamSource sendB = new StreamSource(new StringReader("B"));
        this.template.sendBody("direct:b", (Object)sendB);
        this.template.sendBody("direct:c", (Object)new StreamSource(new StringReader("C")));
        this.assertMockEndpointsSatisfied();
        Object bodyA = ((Exchange)a.getReceivedExchanges().get(0)).getIn().getBody();
        StreamCachingPerRouteTest.assertIsInstanceOf(StreamCache.class, bodyA);
        Object bodyC = ((Exchange)c.getReceivedExchanges().get(0)).getIn().getBody();
        StreamCachingPerRouteTest.assertIsInstanceOf(StreamCache.class, bodyC);
        Object bodyB = ((Exchange)b.getReceivedExchanges().get(0)).getIn().getBody();
        StreamCachingPerRouteTest.assertIsInstanceOf(StreamSource.class, bodyB);
        StreamCachingPerRouteTest.assertSame((String)"Should be same body as we send", (Object)sendB, (Object)bodyB);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                StreamCachingPerRouteTest.this.context.setStreamCaching(Boolean.valueOf(true));
                this.from("direct:a").to("mock:a");
                this.from("direct:b").noStreamCaching().to("mock:b");
                this.from("direct:c").streamCaching().to("mock:c");
            }
        };
    }
}

