/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadsDefinition;

public class ThreadsRequestReplyTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    public void testThreadsInOut() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        ThreadsRequestReplyTest.assertEquals((String)"Bye World", (String)reply);
        this.assertMockEndpointsSatisfied();
        ThreadsRequestReplyTest.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ThreadsRequestReplyTest.this.context.setTracing(Boolean.valueOf(true));
                ((ThreadsDefinition)((ThreadsDefinition)((ThreadsDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).threads(5).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:result")).transform((Expression)this.constant("Bye World"));
            }
        };
    }
}

