/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;

public class ThreadsZeroInCoreAndMaxPoolTest
extends ContextTestSupport {
    public void xtestThreadsCoreAndMaxPool() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testThreadsCoreBeZero() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").threads(0, 2).to("mock:result");
                }
            });
            ThreadsZeroInCoreAndMaxPoolTest.fail((String)"Expect FailedToCreateRouteException exception here");
        }
        catch (FailedToCreateRouteException ex) {
            ThreadsZeroInCoreAndMaxPoolTest.assertTrue((boolean)(ex.getCause() instanceof IllegalArgumentException));
        }
    }

    public void testThreadsCoreAndMaxPoolBuilder() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").threads().maxPoolSize(20).threadName("myPool").to("mock:result");
            }
        };
    }
}

