/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class ThrowExceptionTest
extends ContextTestSupport {
    public void testThrowException() throws Exception {
        this.getMockEndpoint("mock:start").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            ThrowExceptionTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            ThrowExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            ThrowExceptionTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:start")).throwException((Exception)new IllegalArgumentException("Forced"))).to("mock:result");
            }
        };
    }
}

