/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.TryDefinition;

public class TryCatchRecipientListTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testTryCatchTo() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createTryCatchToRouteBuilder());
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"doCatch"});
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:catch").expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)this.getMockEndpoint("mock:catch").message(0).property("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testTryCatchRecipientList() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createTryCatchRecipientListRouteBuilder());
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"doCatch"});
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:catch").expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)this.getMockEndpoint("mock:catch").message(0).property("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testDualTryCatchRecipientList() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createDualTryCatchRecipientListRouteBuilder());
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"doCatch"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"doCatch"});
        this.getMockEndpoint("mock:result2").expectedBodiesReceived(new Object[]{"doCatch2"});
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:catch").expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)this.getMockEndpoint("mock:catch").message(0).property("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.getMockEndpoint("mock:catch2").expectedBodiesReceived(new Object[]{"doCatch"});
        ((ValueBuilder)this.getMockEndpoint("mock:catch2").message(0).property("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testTo() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createToRouteBuilder());
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:dead").message(0).property("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testRecipientList() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRecipientListRouteBuilder());
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:dead").message(0).property("CamelExceptionCaught")).isInstanceOf(IllegalArgumentException.class);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createTryCatchToRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((ProcessorDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("direct:foo")).doCatch(Exception.class).to("mock:catch")).transform().constant((Object)"doCatch")).end().to("mock:result");
                ((RouteDefinition)this.from("direct:foo").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }

    protected RouteBuilder createTryCatchRecipientListRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((ProcessorDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().recipientList((Expression)this.constant("direct:foo")).end()).doCatch(Exception.class).to("mock:catch")).transform().constant((Object)"doCatch")).end().to("mock:result");
                ((RouteDefinition)this.from("direct:foo").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }

    protected RouteBuilder createDualTryCatchRecipientListRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((ProcessorDefinition)((TryDefinition)((TryDefinition)((ProcessorDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().recipientList((Expression)this.constant("direct:foo")).end()).doCatch(Exception.class).to("mock:catch")).transform().constant((Object)"doCatch")).end().to("mock:result").doTry().recipientList((Expression)this.constant("direct:bar")).end()).doCatch(Exception.class).to("mock:catch2")).transform().constant((Object)"doCatch2")).end().to("mock:result2");
                ((RouteDefinition)this.from("direct:foo").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Forced");
                    }
                });
                ((RouteDefinition)this.from("direct:bar").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:bar")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Forced Again");
                    }
                });
            }
        };
    }

    protected RouteBuilder createToRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((RouteDefinition)this.from("direct:start").to("direct:foo")).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }

    protected RouteBuilder createRecipientListRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead"));
                ((RouteDefinition)this.from("direct:start").recipientList((Expression)this.constant("direct:foo")).end()).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").errorHandler((ErrorHandlerFactory)this.noErrorHandler()).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }
}

