/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.UnitOfWorkTest;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;

public class UnitOfWorkSynchronizationAdapterTest
extends UnitOfWorkTest {
    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:async").to("direct:foo");
                this.from("direct:foo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        log.info("Received: " + exchange);
                        exchange.getUnitOfWork().addSynchronization((Synchronization)new SynchronizationAdapter(){

                            public void onComplete(Exchange exchange) {
                                UnitOfWorkSynchronizationAdapterTest.this.completed = exchange;
                                UnitOfWorkSynchronizationAdapterTest.this.doneLatch.countDown();
                            }
                        });
                        exchange.getUnitOfWork().addSynchronization((Synchronization)new SynchronizationAdapter(){

                            public void onFailure(Exchange exchange) {
                                UnitOfWorkSynchronizationAdapterTest.this.failed = exchange;
                                UnitOfWorkSynchronizationAdapterTest.this.doneLatch.countDown();
                            }
                        });
                        String name = UnitOfWorkSynchronizationAdapterTest.this.getName();
                        if (name.equals("testFail")) {
                            log.info("Failing test!");
                            exchange.getOut().setFault(true);
                            exchange.getOut().setBody((Object)"testFail() should always fail with a fault!");
                        } else if (name.equals("testException")) {
                            log.info("Throwing exception!");
                            throw new Exception("Failing test!");
                        }
                    }
                });
            }
        };
    }
}

