/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.Synchronization;

public class UnitOfWorkTest
extends ContextTestSupport {
    protected Synchronization synchronization;
    protected Exchange completed;
    protected Exchange failed;
    protected String uri = "direct:foo";
    protected CountDownLatch doneLatch = new CountDownLatch(1);

    public void testSuccess() throws Exception {
        this.sendMessage();
        UnitOfWorkTest.assertTrue((String)"Exchange did not complete.", (boolean)this.doneLatch.await(5L, TimeUnit.SECONDS));
        UnitOfWorkTest.assertNull((String)"Should not have failed", (Object)this.failed);
        UnitOfWorkTest.assertNotNull((String)"Should have received completed notification", (Object)this.completed);
        this.log.info("Received completed: " + this.completed);
    }

    public void testFail() throws Exception {
        this.sendMessage();
        UnitOfWorkTest.assertTrue((String)"Exchange did not complete.", (boolean)this.doneLatch.await(5L, TimeUnit.SECONDS));
        UnitOfWorkTest.assertNull((String)"Should not have completed", (Object)this.completed);
        UnitOfWorkTest.assertNotNull((String)"Should have received failed notification", (Object)this.failed);
        this.log.info("Received fail: " + this.failed);
    }

    public void testException() throws Exception {
        this.sendMessage();
        UnitOfWorkTest.assertTrue((String)"Exchange did not complete.", (boolean)this.doneLatch.await(5L, TimeUnit.SECONDS));
        UnitOfWorkTest.assertNull((String)"Should not have completed", (Object)this.completed);
        UnitOfWorkTest.assertNotNull((String)"Should have received failed notification", (Object)this.failed);
        this.log.info("Received fail: " + this.failed);
    }

    @Override
    protected void setUp() throws Exception {
        this.synchronization = new Synchronization(){

            public void onComplete(Exchange exchange) {
                UnitOfWorkTest.this.completed = exchange;
                UnitOfWorkTest.this.doneLatch.countDown();
            }

            public void onFailure(Exchange exchange) {
                UnitOfWorkTest.this.failed = exchange;
                UnitOfWorkTest.this.doneLatch.countDown();
            }
        };
        super.setUp();
    }

    protected void sendMessage() throws InterruptedException {
        this.template.send(this.uri, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"<hello>world!</hello>");
            }
        });
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:async").to("direct:foo");
                this.from("direct:foo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        log.info("Received: " + exchange);
                        exchange.getUnitOfWork().addSynchronization(UnitOfWorkTest.this.synchronization);
                        String name = UnitOfWorkTest.this.getName();
                        if (name.equals("testFail")) {
                            log.info("Failing test!");
                            exchange.getOut().setFault(true);
                            exchange.getOut().setBody((Object)"testFail() should always fail with a fault!");
                        } else if (name.equals("testException")) {
                            log.info("Throwing exception!");
                            throw new Exception("Failing test!");
                        }
                    }
                });
            }
        };
    }
}

