/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StringSource;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.validation.NoXmlBodyValidationException;
import org.apache.camel.processor.validation.SchemaValidationException;
import org.apache.camel.processor.validation.ValidatingProcessor;

public class ValidatingProcessorTest
extends ContextTestSupport {
    protected ValidatingProcessor validating;

    @Override
    protected void setUp() throws Exception {
        this.validating = new ValidatingProcessor();
        this.validating.setSchemaFile(new File("src/test/resources/org/apache/camel/processor/ValidatingProcessor.xsd"));
        super.setUp();
    }

    public void testValidMessage() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:valid");
        mock.expectedMessageCount(1);
        String xml = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><user xmlns=\"http://foo.com/bar\">  <id>1</id>  <username>davsclaus</username></user>";
        this.template.sendBody("direct:start", (Object)xml);
        this.assertMockEndpointsSatisfied();
    }

    public void testStringSourceMessage() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:valid");
        mock.expectedMessageCount(1);
        String xml = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><user xmlns=\"http://foo.com/bar\">  <id>1</id>  <username>davsclaus</username></user>";
        this.template.sendBody("direct:start", (Object)new StringSource(xml));
        this.assertMockEndpointsSatisfied();
    }

    public void testValidMessageTwice() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:valid");
        mock.expectedMessageCount(2);
        String xml = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><user xmlns=\"http://foo.com/bar\">  <id>1</id>  <username>davsclaus</username></user>";
        this.template.sendBody("direct:start", (Object)xml);
        this.template.sendBody("direct:start", (Object)xml);
        this.assertMockEndpointsSatisfied();
    }

    public void testInvalidMessage() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:invalid");
        mock.expectedMessageCount(1);
        String xml = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><user xmlns=\"http://foo.com/bar\">  <username>someone</username></user>";
        try {
            this.template.sendBody("direct:start", (Object)xml);
            ValidatingProcessorTest.fail((String)"Should have thrown a RuntimeCamelException");
        }
        catch (RuntimeCamelException e) {
            ValidatingProcessorTest.assertTrue((boolean)(e.getCause() instanceof SchemaValidationException));
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testNonWellFormedXml() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:invalid");
        mock.expectedMessageCount(1);
        String xml = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>user xmlns=\"http://foo.com/bar\">  <id>1</id>  <username>davsclaus</username>";
        try {
            this.template.sendBody("direct:start", (Object)xml);
            ValidatingProcessorTest.fail((String)"Should have thrown a RuntimeCamelException");
        }
        catch (RuntimeCamelException e) {
            ValidatingProcessorTest.assertTrue((boolean)(e.getCause() instanceof SchemaValidationException));
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testNoXMLBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:invalid");
        mock.expectedMessageCount(1);
        try {
            this.template.sendBody("direct:start", null);
            ValidatingProcessorTest.fail((String)"Should have thrown a RuntimeCamelException");
        }
        catch (RuntimeCamelException e) {
            ValidatingProcessorTest.assertIsInstanceOf(NoXmlBodyValidationException.class, e.getCause());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testValidatingOptions() throws Exception {
        ValidatingProcessorTest.assertNotNull((Object)this.validating.getErrorHandler());
        ValidatingProcessorTest.assertNotNull((Object)this.validating.getSchema());
        ValidatingProcessorTest.assertNotNull((Object)this.validating.getSchemaFactory());
        ValidatingProcessorTest.assertNotNull((Object)this.validating.getSchemaFile());
        ValidatingProcessorTest.assertNotNull((Object)this.validating.getSchemaLanguage());
        ValidatingProcessorTest.assertNull((Object)this.validating.getSchemaUrl());
        try {
            ValidatingProcessorTest.assertNotNull((Object)this.validating.getSchemaSource());
            ValidatingProcessorTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                this.onException(ValidationException.class).to("mock:invalid");
                ((RouteDefinition)this.from("direct:start").process((Processor)ValidatingProcessorTest.this.validating)).to("mock:valid");
            }
        };
    }
}

