/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.spi.AggregationRepository;

public class AggregateCompletionOnlyTwoTest
extends ContextTestSupport {
    private MyRepo repo = new MyRepo();

    public void testOnlyTwo() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedBodiesReceived(new Object[]{"A+B", "C+END"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)"foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"END", "id", (Object)"foo");
        this.assertMockEndpointsSatisfied();
        AggregateCompletionOnlyTwoTest.assertEquals((int)4, (int)this.repo.getGet());
        AggregateCompletionOnlyTwoTest.assertEquals((int)2, (int)this.repo.getAdd());
        AggregateCompletionOnlyTwoTest.assertEquals((int)2, (int)this.repo.getRemove());
        AggregateCompletionOnlyTwoTest.assertEquals((int)2, (int)this.repo.getConfirm());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).aggregationRepository((AggregationRepository)AggregateCompletionOnlyTwoTest.this.repo).completionSize(2).to("mock:aggregated");
            }
        };
    }

    private class MyRepo
    extends MemoryAggregationRepository {
        private int add;
        private int get;
        private int remove;
        private int confirm;

        private MyRepo() {
        }

        public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
            ++this.add;
            return super.add(camelContext, key, exchange);
        }

        public Exchange get(CamelContext camelContext, String key) {
            ++this.get;
            return super.get(camelContext, key);
        }

        public void remove(CamelContext camelContext, String key, Exchange exchange) {
            ++this.remove;
            super.remove(camelContext, key, exchange);
        }

        public void confirm(CamelContext camelContext, String exchangeId) {
            ++this.confirm;
            super.confirm(camelContext, exchangeId);
        }

        public Set<String> getKeys() {
            return super.getKeys();
        }

        public int getAdd() {
            return this.add;
        }

        public int getGet() {
            return this.get;
        }

        public int getRemove() {
            return this.remove;
        }

        public int getConfirm() {
            return this.confirm;
        }
    }
}

