/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class AggregateCompletionSizeAndBatchConsumerTest
extends ContextTestSupport {
    public void testAggregateExpressionSize() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"A+A+A", "A", "B+B", "Z"});
        ((ValueBuilder)result.message(0).property("CamelAggregatedCompletedBy")).isEqualTo((Object)"size");
        ((ValueBuilder)result.message(1).property("CamelAggregatedCompletedBy")).isEqualTo((Object)"consumer");
        ((ValueBuilder)result.message(2).property("CamelAggregatedCompletedBy")).isEqualTo((Object)"consumer");
        ((ValueBuilder)result.message(3).property("CamelAggregatedCompletedBy")).isEqualTo((Object)"consumer");
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBodyAndProperty("direct:start", (Object)"Z", "CamelBatchSize", (Object)7);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.body(), (AggregationStrategy)new BodyInAggregatingStrategy()).completionSize(3).completionFromBatchConsumer().to(new String[]{"log:result", "mock:result"});
            }
        };
    }
}

