/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class AggregateExpressionTimeoutPerGroupTest
extends ContextTestSupport {
    public void testAggregateExpressionPerGroupTimeout() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceived(new Object[]{"G+H+I", "D+E+F", "A+B+C"});
        this.template.sendBodyAndHeader("direct:start", (Object)"A", "id", (Object)789);
        this.template.sendBodyAndHeader("direct:start", (Object)"B", "id", (Object)789);
        this.template.sendBodyAndHeader("direct:start", (Object)"C", "id", (Object)789);
        HashMap<String, Integer> headers = new HashMap<String, Integer>();
        headers.put("id", 123);
        headers.put("timeout", 3000);
        this.template.sendBodyAndHeaders("direct:start", (Object)"D", headers);
        this.template.sendBodyAndHeaders("direct:start", (Object)"E", headers);
        this.template.sendBodyAndHeaders("direct:start", (Object)"F", headers);
        HashMap<String, Integer> headers2 = new HashMap<String, Integer>();
        headers2.put("id", 456);
        headers2.put("timeout", 1000);
        this.template.sendBodyAndHeaders("direct:start", (Object)"G", headers2);
        this.template.sendBodyAndHeaders("direct:start", (Object)"H", headers2);
        this.template.sendBodyAndHeaders("direct:start", (Object)"I", headers2);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionTimeout((Expression)this.header("timeout")).completionTimeout(5000L).to("mock:aggregated");
            }
        };
    }
}

