/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class AggregateGroupedExchangeBatchSizeTest
extends ContextTestSupport {
    public void testGrouped() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMinimumMessageCount(1);
        this.template.sendBody("direct:start", (Object)"100");
        this.template.sendBody("direct:start", (Object)"150");
        this.template.sendBody("direct:start", (Object)"130");
        this.template.sendBody("direct:start", (Object)"200");
        this.assertMockEndpointsSatisfied();
        Exchange out = (Exchange)result.getExchanges().get(0);
        List grouped = (List)out.getProperty("CamelGroupedExchange", List.class);
        AggregateGroupedExchangeBatchSizeTest.assertTrue((String)("Should be either 2 or 4, was " + grouped.size()), (grouped.size() == 2 || grouped.size() == 4 ? 1 : 0) != 0);
        AggregateGroupedExchangeBatchSizeTest.assertEquals((String)"100", (String)((String)((Exchange)grouped.get(0)).getIn().getBody(String.class)));
        AggregateGroupedExchangeBatchSizeTest.assertEquals((String)"150", (String)((String)((Exchange)grouped.get(1)).getIn().getBody(String.class)));
        Thread.sleep(1000L);
        if (result.getReceivedCounter() == 2) {
            out = (Exchange)result.getExchanges().get(1);
            grouped = (List)out.getProperty("CamelGroupedExchange", List.class);
            AggregateGroupedExchangeBatchSizeTest.assertEquals((int)2, (int)grouped.size());
            AggregateGroupedExchangeBatchSizeTest.assertEquals((String)"130", (String)((String)((Exchange)grouped.get(0)).getIn().getBody(String.class)));
            AggregateGroupedExchangeBatchSizeTest.assertEquals((String)"200", (String)((String)((Exchange)grouped.get(1)).getIn().getBody(String.class)));
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").log("Aggregator received ${body}")).aggregate((Expression)this.constant(true)).completionSize(2).completionTimeout(500L).groupExchanges().to("mock:result");
            }
        };
    }
}

