/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;

public class AggregateGroupedExchangeSizePredicateTest
extends ContextTestSupport {
    public void testGroupedSize() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(2);
        this.template.sendBodyAndHeader("direct:start", (Object)"100", "groupSize", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"150", "groupSize", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"130", "groupSize", (Object)3);
        this.template.sendBodyAndHeader("direct:start", (Object)"200", "groupSize", (Object)2);
        this.template.sendBodyAndHeader("direct:start", (Object)"190", "groupSize", (Object)2);
        this.assertMockEndpointsSatisfied();
        Exchange out = (Exchange)result.getExchanges().get(0);
        List grouped = (List)out.getProperty("CamelGroupedExchange", List.class);
        AggregateGroupedExchangeSizePredicateTest.assertEquals((int)3, (int)grouped.size());
        AggregateGroupedExchangeSizePredicateTest.assertEquals((String)"100", (String)((String)((Exchange)grouped.get(0)).getIn().getBody(String.class)));
        AggregateGroupedExchangeSizePredicateTest.assertEquals((String)"150", (String)((String)((Exchange)grouped.get(1)).getIn().getBody(String.class)));
        AggregateGroupedExchangeSizePredicateTest.assertEquals((String)"130", (String)((String)((Exchange)grouped.get(2)).getIn().getBody(String.class)));
        out = (Exchange)result.getExchanges().get(1);
        grouped = (List)out.getProperty("CamelGroupedExchange", List.class);
        AggregateGroupedExchangeSizePredicateTest.assertEquals((int)2, (int)grouped.size());
        AggregateGroupedExchangeSizePredicateTest.assertEquals((String)"200", (String)((String)((Exchange)grouped.get(0)).getIn().getBody(String.class)));
        AggregateGroupedExchangeSizePredicateTest.assertEquals((String)"190", (String)((String)((Exchange)grouped.get(1)).getIn().getBody(String.class)));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((AggregateDefinition)this.from("direct:start").aggregate((Expression)this.constant(true)).groupExchanges().eagerCheckCompletion().completionSize((Expression)this.header("groupSize")).to("mock:result")).end();
            }
        };
    }
}

