/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.aggregate.AbstractListAggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class CustomListAggregationStrategySplitTest
extends ContextTestSupport {
    public void testCustomAggregationStrategy() throws Exception {
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{100, 150, 130});
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        ((ValueBuilder)result.message(0).body()).isInstanceOf(List.class);
        ArrayList<String> body = new ArrayList<String>();
        body.add("100");
        body.add("150");
        body.add("130");
        this.template.sendBody("direct:start", body);
        this.assertMockEndpointsSatisfied();
        List numbers = (List)((Exchange)result.getExchanges().get(0)).getIn().getBody(List.class);
        CustomListAggregationStrategySplitTest.assertNotNull((Object)numbers);
        CustomListAggregationStrategySplitTest.assertEquals((Object)Integer.valueOf("100"), numbers.get(0));
        CustomListAggregationStrategySplitTest.assertEquals((Object)Integer.valueOf("150"), numbers.get(1));
        CustomListAggregationStrategySplitTest.assertEquals((Object)Integer.valueOf("130"), numbers.get(2));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body(), (AggregationStrategy)new MyListOfNumbersStrategy()).to("mock:line")).end().to("mock:result");
            }
        };
    }

    public final class MyListOfNumbersStrategy
    extends AbstractListAggregationStrategy<Integer> {
        public Integer getValue(Exchange exchange) {
            String s = (String)exchange.getIn().getBody(String.class);
            return Integer.valueOf(s);
        }
    }
}

