/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ThreadsDefinition;

public class AsyncDeadLetterChannelTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testAsyncErrorHandlerWait() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").maximumRedeliveries(2).redeliveryDelay(0L).logStackTrace(false));
                ((ThreadsDefinition)this.from("direct:in").threads(2).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new Exception("Forced exception by unit test");
                    }
                });
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.requestBody("direct:in", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

