/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.RoutePolicySupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.RoutePolicy;

public class AsyncEndpointCustomRoutePolicyTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;
    private final MyCustomRoutePolicy policy = new MyCustomRoutePolicy();

    public void testAsyncEndpoint() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointCustomRoutePolicyTest.assertEquals((String)"Bye Camel", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncEndpointCustomRoutePolicyTest.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
        mock.reset();
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"stop");
        mock.assertIsSatisfied();
        Thread.sleep(500L);
        AsyncEndpointCustomRoutePolicyTest.assertTrue((String)"Should be stopped", (boolean)this.policy.isStopped());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointCustomRoutePolicyTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").routePolicy(new RoutePolicy[]{AsyncEndpointCustomRoutePolicyTest.this.policy}).to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("async:bye:camel")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:after")).to("mock:result");
            }
        };
    }

    private static class MyCustomRoutePolicy
    extends RoutePolicySupport {
        private volatile int invoked;
        private volatile AtomicBoolean stopped = new AtomicBoolean();

        private MyCustomRoutePolicy() {
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            ++this.invoked;
            if (this.invoked >= 2) {
                try {
                    this.stopped.set(true);
                    this.stopConsumer(route.getConsumer());
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }

        public boolean isStopped() {
            return this.stopped.get();
        }
    }
}

