/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.EventObject;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.EventNotifierSupport;

public class AsyncEndpointEventNotifierTest
extends ContextTestSupport {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicLong time = new AtomicLong();

    public void testAsyncEndpointEventNotifier() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointEventNotifierTest.assertEquals((String)"Bye Camel", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncEndpointEventNotifierTest.assertTrue((String)"Should count down", (boolean)this.latch.await(10L, TimeUnit.SECONDS));
        long delta = this.time.get();
        this.log.info("ExchangeEventSent took ms: " + delta);
        AsyncEndpointEventNotifierTest.assertTrue((String)("Should take about 250 millis sec, was: " + delta), (delta > 200L ? 1 : 0) != 0);
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notify(EventObject event) throws Exception {
                try {
                    ExchangeSentEvent sent = (ExchangeSentEvent)event;
                    AsyncEndpointEventNotifierTest.this.time.set(sent.getTimeTaken());
                }
                finally {
                    AsyncEndpointEventNotifierTest.this.latch.countDown();
                }
            }

            public boolean isEnabled(EventObject event) {
                if (event instanceof ExchangeSentEvent) {
                    ExchangeSentEvent sent = (ExchangeSentEvent)event;
                    return sent.getEndpoint().getEndpointUri().startsWith("async");
                }
                return false;
            }

            protected void doStart() throws Exception {
            }

            protected void doStop() throws Exception {
            }
        });
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointEventNotifierTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("async:bye:camel?delay=250")).to("mock:result");
            }
        };
    }
}

