/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.exceptionpolicy;

import java.util.Map;
import org.apache.camel.CamelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyKey;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;

public class CustomExceptionPolicyStrategyTest
extends ContextTestSupport {
    private static final String MESSAGE_INFO = "messageInfo";
    private static final String ERROR_QUEUE = "mock:error";

    public void testCustomPolicy() throws Exception {
        MockEndpoint mock = this.getMockEndpoint(ERROR_QUEUE);
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived(MESSAGE_INFO, (Object)"Damm my policy exception");
        try {
            this.template.sendBody("direct:a", (Object)"Hello Camel");
            CustomExceptionPolicyStrategyTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel(CustomExceptionPolicyStrategyTest.ERROR_QUEUE).exceptionPolicyStrategy((ExceptionPolicyStrategy)new MyPolicy()));
                ((OnExceptionDefinition)this.onException(MyPolicyException.class).maximumRedeliveries(1).setHeader(CustomExceptionPolicyStrategyTest.MESSAGE_INFO, (Expression)this.constant("Damm my policy exception"))).to(CustomExceptionPolicyStrategyTest.ERROR_QUEUE);
                ((OnExceptionDefinition)this.onException(CamelException.class).maximumRedeliveries(3).setHeader(CustomExceptionPolicyStrategyTest.MESSAGE_INFO, (Expression)this.constant("Damm a Camel exception"))).to(CustomExceptionPolicyStrategyTest.ERROR_QUEUE);
                ((RouteDefinition)this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String s = (String)exchange.getIn().getBody(String.class);
                        if ("Hello Camel".equals(s)) {
                            throw new CamelExchangeException("Forced for testing", exchange);
                        }
                        exchange.getOut().setBody((Object)"Hello World");
                    }
                })).to("mock:result");
            }
        };
    }

    public static class MyPolicy
    implements ExceptionPolicyStrategy {
        public OnExceptionDefinition getExceptionPolicy(Map<ExceptionPolicyKey, OnExceptionDefinition> exceptionPolicices, Exchange exchange, Throwable exception) {
            return exceptionPolicices.get(new ExceptionPolicyKey(null, MyPolicyException.class, null));
        }
    }

    public static class MyPolicyException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

