/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;

public class InterceptFromEndpointRefUriTest
extends ContextTestSupport {
    private SimpleRegistry reg = new SimpleRegistry();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        return new DefaultCamelContext((Registry)this.reg);
    }

    public void testIntercept() throws Exception {
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(1);
        this.getMockEndpoint("mock:first").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                InterceptFromEndpointRefUriTest.this.reg.put((Object)"start", (Object)InterceptFromEndpointRefUriTest.this.context.getEndpoint("direct:start"));
                InterceptFromEndpointRefUriTest.this.reg.put((Object)"bar", (Object)InterceptFromEndpointRefUriTest.this.context.getEndpoint("seda:bar"));
                this.interceptFrom("direct*").to("mock:intercepted");
                ((RouteDefinition)this.from("ref:start").to("mock:first")).to("ref:bar");
                this.from("ref:bar").to("mock:result");
            }
        };
    }
}

