/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;

public class AdviceWithTasksSelectTest
extends ContextTestSupport {
    public void testSelectFirst() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectFirst().replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSelectLast() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectLast().replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSelectIndexZero() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectIndex(0).replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSelectIndexOne() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectIndex(1).replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSelectIndexTwo() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectIndex(2).replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSelectIndexOutOfBounds() throws Exception {
        try {
            ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

                public void configure() throws Exception {
                    ((MulticastDefinition)this.weaveById("gold*").selectIndex(3).replace().multicast().to("mock:a")).to("mock:b");
                }
            });
            AdviceWithTasksSelectTest.fail((String)"Should hve thrown exception");
        }
        catch (IllegalArgumentException e) {
            AdviceWithTasksSelectTest.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith("There are no outputs which matches: gold* in the route"));
        }
    }

    public void testSelectRangeZeroOne() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectRange(0, 1).replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.getMockEndpoint("mock:a").expectedMessageCount(2);
        this.getMockEndpoint("mock:b").expectedMessageCount(2);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSelectRangeOneTwo() throws Exception {
        ((RouteDefinition)this.context.getRouteDefinitions().get(0)).adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.weaveById("gold*").selectRange(1, 2).replace().multicast().to("mock:a")).to("mock:b");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        this.getMockEndpoint("mock:a").expectedMessageCount(2);
        this.getMockEndpoint("mock:b").expectedMessageCount(2);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").log("Got ${body}")).id("foo")).to("mock:foo")).id("gold-1")).to("mock:bar")).id("gold-2")).to("mock:baz")).id("gold-3")).to("mock:result")).id("silver-1");
            }
        };
    }
}

