/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.BreakpointSupport;
import org.apache.camel.impl.ConditionSupport;
import org.apache.camel.impl.DefaultDebugger;
import org.apache.camel.management.event.AbstractExchangeEvent;
import org.apache.camel.management.event.ExchangeFailedEvent;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Breakpoint;
import org.apache.camel.spi.Condition;
import org.apache.camel.spi.Debugger;

public class DebugExceptionEventBreakpointTest
extends ContextTestSupport {
    private List<String> logs = new ArrayList<String>();
    private Condition exceptionCondition;
    private Breakpoint breakpoint;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.breakpoint = new BreakpointSupport(){

            public void onEvent(Exchange exchange, EventObject event, ProcessorDefinition<?> definition) {
                AbstractExchangeEvent aee = (AbstractExchangeEvent)event;
                Exception e = aee.getExchange().getException();
                DebugExceptionEventBreakpointTest.this.logs.add("Breakpoint at " + definition + " caused by: " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]");
            }
        };
        this.exceptionCondition = new ConditionSupport(){

            public boolean matchEvent(Exchange exchange, EventObject event) {
                return event instanceof ExchangeFailedEvent;
            }
        };
    }

    public void testDebug() throws Exception {
        this.context.getDebugger().addBreakpoint(this.breakpoint, new Condition[]{this.exceptionCondition});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        try {
            this.template.sendBody("direct:start", (Object)"Hello Camel");
            DebugExceptionEventBreakpointTest.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        DebugExceptionEventBreakpointTest.assertEquals((int)1, (int)this.logs.size());
        DebugExceptionEventBreakpointTest.assertEquals((String)"Breakpoint at ThrowException[java.lang.IllegalArgumentException] caused by: IllegalArgumentException[Damn]", (String)this.logs.get(0));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                DebugExceptionEventBreakpointTest.this.context.setDebugger((Debugger)new DefaultDebugger());
                ((ChoiceDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).choice().when(this.body().contains((Object)"Camel")).throwException((Exception)new IllegalArgumentException("Damn"))).end().to("mock:result");
            }
        };
    }
}

