/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.LinkedList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.TraceEventHandler;
import org.apache.camel.processor.interceptor.TraceInterceptor;

public class TraceHandlerTestHandler
implements TraceEventHandler {
    private List<StringBuilder> eventMessages;
    private boolean traceAllNodes;

    public TraceHandlerTestHandler() {
        this.eventMessages = new LinkedList<StringBuilder>();
        this.traceAllNodes = false;
    }

    public TraceHandlerTestHandler(List<StringBuilder> eventMessages) {
        this.eventMessages = eventMessages;
        this.traceAllNodes = false;
    }

    public List<StringBuilder> getEventMessages() {
        return this.eventMessages;
    }

    public void setEventMessages(List<StringBuilder> eventMessages) {
        this.eventMessages = eventMessages;
    }

    public boolean isTraceAllNodes() {
        return this.traceAllNodes;
    }

    public void setTraceAllNodes(boolean traceAllNodes) {
        this.traceAllNodes = traceAllNodes;
    }

    private synchronized void storeMessage(StringBuilder message) {
        this.eventMessages.add(message);
    }

    public static void recordComplete(StringBuilder message, ProcessorDefinition<?> node, Exchange exchange) {
        message.append("Complete: ");
        message.append(node.getLabel() + ": ");
        message.append(exchange.getIn().getBody());
    }

    public static void recordIn(StringBuilder message, ProcessorDefinition<?> node, Exchange exchange) {
        message.append("In: ");
        message.append(node.getLabel() + ": ");
        message.append(exchange.getIn().getBody());
    }

    public static void recordOut(StringBuilder message, ProcessorDefinition<?> node, Exchange exchange) {
        message.append("Out: ");
        message.append(node.getLabel() + ": ");
        if (null != exchange.getOut()) {
            message.append(exchange.getOut().getBody());
        }
        if (null != exchange.getException()) {
            Exception ex = exchange.getException();
            message.append("\t");
            message.append("Ex: ");
            message.append(ex.getMessage());
        }
    }

    public void traceExchange(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange) throws Exception {
        if (this.traceAllNodes || !node.getLabel().contains("TraceTestProcessor")) {
            StringBuilder message = new StringBuilder();
            TraceHandlerTestHandler.recordComplete(message, node, exchange);
            this.storeMessage(message);
        }
    }

    public Object traceExchangeIn(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange) throws Exception {
        if (this.traceAllNodes || !node.getLabel().contains("TraceTestProcessor")) {
            StringBuilder message = new StringBuilder();
            TraceHandlerTestHandler.recordIn(message, node, exchange);
            return message;
        }
        return null;
    }

    public void traceExchangeOut(ProcessorDefinition<?> node, Processor target, TraceInterceptor traceInterceptor, Exchange exchange, Object traceState) throws Exception {
        if ((this.traceAllNodes || !node.getLabel().contains("TraceTestProcessor")) && StringBuilder.class.equals(traceState.getClass())) {
            StringBuilder message = (StringBuilder)traceState;
            TraceHandlerTestHandler.recordOut(message, node, exchange);
            this.storeMessage(message);
        }
    }
}

