/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.onexception.MyFunctionalException;

public class OnExceptionHandleAndTransformWithDefaultErrorHandlerTest
extends ContextTestSupport {
    public void testOnExceptionTransformConstant() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(MyFunctionalException.class).handled(true).transform().constant((Object)"Sorry");
                this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new MyFunctionalException("Sorry you cannot do this");
                    }
                });
            }
        });
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        OnExceptionHandleAndTransformWithDefaultErrorHandlerTest.assertEquals((Object)"Sorry", (Object)out);
    }

    public void testOnExceptionTransformExceptionMessage() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(MyFunctionalException.class).handled(true).transform((Expression)this.exceptionMessage());
                this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new MyFunctionalException("Sorry you cannot do this again to me");
                    }
                });
            }
        });
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        OnExceptionHandleAndTransformWithDefaultErrorHandlerTest.assertEquals((Object)"Sorry you cannot do this again to me", (Object)out);
    }

    public void testOnExceptionSimpleLangaugeExceptionMessage() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(MyFunctionalException.class).handled(true).transform().simple("Error reported: ${exception.message} - cannot process this message.");
                this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new MyFunctionalException("Out of order");
                    }
                });
            }
        });
        Object out = this.template.requestBody("direct:start", (Object)"Hello World");
        OnExceptionHandleAndTransformWithDefaultErrorHandlerTest.assertEquals((Object)"Error reported: Out of order - cannot process this message.", (Object)out);
    }
}

