/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import java.io.IOException;
import javax.xml.soap.SOAPException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;

public class OnExceptionMisconfiguredTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testOnExceptionMisconfigured() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class);
                this.from("direct:start").to("mock:result");
            }
        });
        try {
            this.context.start();
            OnExceptionMisconfiguredTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            IllegalArgumentException iae = OnExceptionMisconfiguredTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            OnExceptionMisconfiguredTest.assertEquals((String)"OnException[[class java.lang.Exception] -> []] is not configured.", (String)iae.getMessage());
        }
    }

    public void testOnExceptionMisconfigured2() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).end();
                this.from("direct:start").to("mock:result");
            }
        });
        try {
            this.context.start();
            OnExceptionMisconfiguredTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            IllegalArgumentException iae = OnExceptionMisconfiguredTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            OnExceptionMisconfiguredTest.assertEquals((String)"OnException[[class java.lang.Exception] -> []] is not configured.", (String)iae.getMessage());
        }
    }

    public void testOnExceptionMisconfigured3() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(new Class[0]);
                this.from("direct:start").to("mock:result");
            }
        });
        try {
            this.context.start();
            OnExceptionMisconfiguredTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            IllegalArgumentException iae = OnExceptionMisconfiguredTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            OnExceptionMisconfiguredTest.assertEquals((String)"OnException[[class java.lang.Exception] -> []] is not configured.", (String)iae.getMessage());
        }
    }

    public void testOnExceptionMisconfigured4() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(new Class[0]).end();
                this.from("direct:start").to("mock:result");
            }
        });
        try {
            this.context.start();
            OnExceptionMisconfiguredTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            IllegalArgumentException iae = OnExceptionMisconfiguredTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            OnExceptionMisconfiguredTest.assertEquals((String)"OnException[[class java.lang.Exception] -> []] is not configured.", (String)iae.getMessage());
        }
    }

    public void testOnExceptionMisconfigured5() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").onException(new Class[0]).end().to("mock:result");
            }
        });
        try {
            this.context.start();
            OnExceptionMisconfiguredTest.fail((String)"Should have thrown exception");
        }
        catch (FailedToCreateRouteException e) {
            IllegalArgumentException iae = OnExceptionMisconfiguredTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            OnExceptionMisconfiguredTest.assertTrue((boolean)iae.getMessage().startsWith("At least one exception must be configured"));
        }
    }

    public void testOnExceptionNotMisconfigured() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(new Class[0]).handled(true);
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
    }

    public void testOnExceptionNotMisconfigured2() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(new Class[0]).continued(true);
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
    }

    public void testOnExceptionNotMisconfigured3() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).handled(true);
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
    }

    public void testOnExceptionNotMisconfigured4() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).continued(true);
                this.from("direct:start").to("mock:result");
            }
        });
        this.context.start();
    }

    public void testOnExceptionNotMisconfigured5() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.from("direct:start").onException(SOAPException.class).onException(IOException.class).to("mock:error")).end().to("mock:result");
            }
        });
        this.context.start();
    }
}

