/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.util.URISupport;

public class URISupportTest
extends ContextTestSupport {
    public void testNormalizeEndpointUri() throws Exception {
        String out1 = URISupport.normalizeUri((String)"smtp://localhost?username=davsclaus&password=secret");
        String out2 = URISupport.normalizeUri((String)"smtp://localhost?password=secret&username=davsclaus");
        URISupportTest.assertEquals((String)out1, (String)out2);
        out1 = URISupport.normalizeUri((String)"smtp://localhost?username=davsclaus&password=secret");
        out2 = URISupport.normalizeUri((String)"smtp:localhost?password=secret&username=davsclaus");
        URISupportTest.assertEquals((String)out1, (String)out2);
        out1 = URISupport.normalizeUri((String)"smtp:localhost?password=secret&username=davsclaus");
        out2 = URISupport.normalizeUri((String)"smtp://localhost?username=davsclaus&password=secret");
        URISupportTest.assertEquals((String)out1, (String)out2);
        out1 = URISupport.normalizeUri((String)"seda:foo?concurrentConsumer=2");
        out2 = URISupport.normalizeUri((String)"seda:foo?concurrentConsumer=2");
        URISupportTest.assertEquals((String)out1, (String)out2);
        out1 = URISupport.normalizeUri((String)"seda:foo?concurrentConsumer=2");
        out2 = URISupport.normalizeUri((String)"seda:foo");
        URISupportTest.assertNotSame((Object)out1, (Object)out2);
        out1 = URISupport.normalizeUri((String)"foo:?test=1");
        out2 = URISupport.normalizeUri((String)"foo://?test=1");
        URISupportTest.assertEquals((String)"foo://?test=1", (String)out2);
        URISupportTest.assertEquals((String)out1, (String)out2);
    }

    public void testNormalizeEndpointUriNoParam() throws Exception {
        String out1 = URISupport.normalizeUri((String)"direct:foo");
        String out2 = URISupport.normalizeUri((String)"direct:foo");
        URISupportTest.assertEquals((String)out1, (String)out2);
        out1 = URISupport.normalizeUri((String)"direct://foo");
        out2 = URISupport.normalizeUri((String)"direct://foo");
        URISupportTest.assertEquals((String)out1, (String)out2);
        out1 = URISupport.normalizeUri((String)"direct:foo");
        out2 = URISupport.normalizeUri((String)"direct://foo");
        URISupportTest.assertEquals((String)out1, (String)out2);
        out1 = URISupport.normalizeUri((String)"direct://foo");
        out2 = URISupport.normalizeUri((String)"direct:foo");
        URISupportTest.assertEquals((String)out1, (String)out2);
        out1 = URISupport.normalizeUri((String)"direct://foo");
        out2 = URISupport.normalizeUri((String)"direct:bar");
        URISupportTest.assertNotSame((Object)out1, (Object)out2);
    }

    public void testNormalizeEndpointUriWithFragments() throws Exception {
        String out1 = URISupport.normalizeUri((String)"irc://someserver/#camel?user=davsclaus");
        String out2 = URISupport.normalizeUri((String)"irc:someserver/#camel?user=davsclaus");
        URISupportTest.assertEquals((String)out1, (String)out2);
        out1 = URISupport.normalizeUri((String)"irc://someserver/#camel?user=davsclaus");
        out2 = URISupport.normalizeUri((String)"irc:someserver/#camel?user=hadrian");
        URISupportTest.assertNotSame((Object)out1, (Object)out2);
    }

    public void testNormalizeHttpEndpoint() throws Exception {
        String out1 = URISupport.normalizeUri((String)"http://www.google.com?q=Camel");
        String out2 = URISupport.normalizeUri((String)"http:www.google.com?q=Camel");
        URISupportTest.assertEquals((String)out1, (String)out2);
        URISupportTest.assertTrue((String)"Should have //", (boolean)out1.startsWith("http://"));
        URISupportTest.assertTrue((String)"Should have //", (boolean)out2.startsWith("http://"));
    }

    public void testNormalizeIPv6HttpEndpoint() throws Exception {
        String result = URISupport.normalizeUri((String)"http://[2a00:8a00:6000:40::1413]:30300/test");
        URISupportTest.assertEquals((String)"http://[2a00:8a00:6000:40::1413]:30300/test", (String)result);
    }

    public void testNormalizeHttpEndpointUnicodedParameter() throws Exception {
        String out = URISupport.normalizeUri((String)"http://www.google.com?q=S\u00f8ren");
        URISupportTest.assertEquals((String)"http://www.google.com?q=S%C3%B8ren", (String)out);
    }

    public void testParseParametersUnicodedValue() throws Exception {
        String out = URISupport.normalizeUri((String)"http://www.google.com?q=S\u00f8ren");
        URI uri = new URI(out);
        Map parameters = URISupport.parseParameters((URI)uri);
        URISupportTest.assertEquals((int)1, (int)parameters.size());
        URISupportTest.assertEquals((Object)"S\u00f8ren", parameters.get("q"));
    }

    public void testNormalizeHttpEndpointURLEncodedParameter() throws Exception {
        String out = URISupport.normalizeUri((String)"http://www.google.com?q=S%C3%B8ren%20Hansen");
        URISupportTest.assertEquals((String)"http://www.google.com?q=S%C3%B8ren+Hansen", (String)out);
    }

    public void testParseParametersURLEncodeddValue() throws Exception {
        String out = URISupport.normalizeUri((String)"http://www.google.com?q=S%C3%B8ren+Hansen");
        URI uri = new URI(out);
        Map parameters = URISupport.parseParameters((URI)uri);
        URISupportTest.assertEquals((int)1, (int)parameters.size());
        URISupportTest.assertEquals((Object)"S\u00f8ren Hansen", parameters.get("q"));
    }

    public void testNormalizeUriWhereParamererIsFaulty() throws Exception {
        String out = URISupport.normalizeUri((String)"stream:uri?file:///d:/temp/data/log/quickfix.log&scanStream=true");
        URISupportTest.assertNotNull((Object)out);
    }

    public void testCreateRemaingURI() throws Exception {
        URI original = new URI("http://camel.apache.org");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("foo", "123");
        URI newUri = URISupport.createRemainingURI((URI)original, param);
        URISupportTest.assertNotNull((Object)newUri);
        String s = newUri.toString();
        URISupportTest.assertEquals((String)"http://camel.apache.org?foo=123", (String)s);
    }

    public void testCreateURIWithQueryHasOneFragment() throws Exception {
        URI uri = new URI("smtp://localhost#fragmentOne");
        URI resultUri = URISupport.createURIWithQuery((URI)uri, null);
        URISupportTest.assertNotNull((Object)resultUri);
        URISupportTest.assertEquals((String)"smtp://localhost#fragmentOne", (String)resultUri.toString());
    }

    public void testNormalizeEndpointWithEqualSignInParameter() throws Exception {
        String out = URISupport.normalizeUri((String)"jms:queue:foo?selector=somekey='somevalue'&foo=bar");
        URISupportTest.assertNotNull((Object)out);
        URISupportTest.assertEquals((String)"jms://queue:foo?foo=bar&selector=somekey%3D%27somevalue%27", (String)out);
    }

    public void testNormalizeEndpointWithPercentSignInParameter() throws Exception {
        String out = URISupport.normalizeUri((String)"http://someendpoint?username=james&password=%25test");
        URISupportTest.assertNotNull((Object)out);
        URISupportTest.assertEquals((String)"http://someendpoint?password=%25test&username=james", (String)out);
    }

    public void testParseParameters() throws Exception {
        URI u = new URI("quartz:myGroup/myTimerName?cron=0+0+*+*+*+?");
        Map params = URISupport.parseParameters((URI)u);
        URISupportTest.assertEquals((int)1, (int)params.size());
        URISupportTest.assertEquals((Object)"0 0 * * * ?", params.get("cron"));
        u = new URI("quartz:myGroup/myTimerName?cron=0+0+*+*+*+?&bar=123");
        params = URISupport.parseParameters((URI)u);
        URISupportTest.assertEquals((int)2, (int)params.size());
        URISupportTest.assertEquals((Object)"0 0 * * * ?", params.get("cron"));
        URISupportTest.assertEquals((Object)"123", params.get("bar"));
    }

    public void testCreateRemainingURIEncoding() throws Exception {
        String uri = "http://localhost:23271/myapp/mytest?columns=name%2Ctotalsens%2Cupsens&username=apiuser";
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("foo", "abc def");
        map.put("bar", "123,456");
        map.put("name", "S\u00f8ren");
        URI out = URISupport.createRemainingURI((URI)new URI(uri), map);
        URISupportTest.assertNotNull((Object)out);
        URISupportTest.assertEquals((String)"http://localhost:23271/myapp/mytest?foo=abc+def&bar=123%2C456&name=S%C3%B8ren", (String)out.toString());
        URISupportTest.assertEquals((String)"http://localhost:23271/myapp/mytest?foo=abc+def&bar=123%2C456&name=S%C3%B8ren", (String)out.toASCIIString());
    }

    public void testNormalizeEndpointUriWithDualParameters() throws Exception {
        String out1 = URISupport.normalizeUri((String)"smtp://localhost?to=foo&to=bar&from=me");
        URISupportTest.assertEquals((String)"smtp://localhost?from=me&to=foo&to=bar", (String)out1);
        String out2 = URISupport.normalizeUri((String)"smtp://localhost?to=foo&to=bar&from=me&from=you");
        URISupportTest.assertEquals((String)"smtp://localhost?from=me&from=you&to=foo&to=bar", (String)out2);
    }

    public void testSanitizeUriWithUserInfo() {
        String uri = "jt400://GEORGE:HARRISON@LIVERPOOL/QSYS.LIB/BEATLES.LIB/PENNYLANE.DTAQ";
        String expected = "jt400://GEORGE:xxxxxx@LIVERPOOL/QSYS.LIB/BEATLES.LIB/PENNYLANE.DTAQ";
        URISupportTest.assertEquals((String)expected, (String)URISupport.sanitizeUri((String)uri));
    }

    public void testSanitizePathWithUserInfo() {
        String path = "GEORGE:HARRISON@LIVERPOOL/QSYS.LIB/BEATLES.LIB/PENNYLANE.PGM";
        String expected = "GEORGE:xxxxxx@LIVERPOOL/QSYS.LIB/BEATLES.LIB/PENNYLANE.PGM";
        URISupportTest.assertEquals((String)expected, (String)URISupport.sanitizePath((String)path));
    }

    public void testSanitizePathWithoutSensitiveInfoIsUnchanged() {
        String path = "myhost:8080/mypath";
        URISupportTest.assertEquals((String)path, (String)URISupport.sanitizePath((String)path));
    }

    public void testNormalizeEndpointUriWithUserInfoSpecialSign() throws Exception {
        String out1 = URISupport.normalizeUri((String)"ftp://us%40r:t%st@localhost:21000/tmp3/camel?foo=us@r");
        URISupportTest.assertEquals((String)"ftp://us%40r:t%25st@localhost:21000/tmp3/camel?foo=us%40r", (String)out1);
        String out2 = URISupport.normalizeUri((String)"ftp://us%40r:t%25st@localhost:21000/tmp3/camel?foo=us@r");
        URISupportTest.assertEquals((String)"ftp://us%40r:t%25st@localhost:21000/tmp3/camel?foo=us%40r", (String)out2);
        String out3 = URISupport.normalizeUri((String)"ftp://us@r:t%st@localhost:21000/tmp3/camel?foo=us@r");
        URISupportTest.assertEquals((String)"ftp://us%40r:t%25st@localhost:21000/tmp3/camel?foo=us%40r", (String)out3);
        String out4 = URISupport.normalizeUri((String)"ftp://us@r:t%25st@localhost:21000/tmp3/camel?foo=us@r");
        URISupportTest.assertEquals((String)"ftp://us%40r:t%25st@localhost:21000/tmp3/camel?foo=us%40r", (String)out4);
    }

    public void testSpecialUriFromXmppComponent() throws Exception {
        String out1 = URISupport.normalizeUri((String)"xmpp://camel-user@localhost:123/test-user@localhost?password=secret&serviceName=someCoolChat");
        URISupportTest.assertEquals((String)"xmpp://camel-user@localhost:123/test-user@localhost?password=secret&serviceName=someCoolChat", (String)out1);
    }

    public void testRawParameter() throws Exception {
        String out = URISupport.normalizeUri((String)"xmpp://camel-user@localhost:123/test-user@localhost?password=RAW(++?w0rd)&serviceName=some chat");
        URISupportTest.assertEquals((String)"xmpp://camel-user@localhost:123/test-user@localhost?password=RAW(++?w0rd)&serviceName=some+chat", (String)out);
        String out2 = URISupport.normalizeUri((String)"xmpp://camel-user@localhost:123/test-user@localhost?password=RAW(foo %% bar)&serviceName=some chat");
        URISupportTest.assertEquals((String)"xmpp://camel-user@localhost:123/test-user@localhost?password=RAW(foo %% bar)&serviceName=some+chat", (String)out2);
    }

    public void testParseQuery() throws Exception {
        Map map = URISupport.parseQuery((String)"password=secret&serviceName=somechat");
        URISupportTest.assertEquals((int)2, (int)map.size());
        URISupportTest.assertEquals((Object)"secret", map.get("password"));
        URISupportTest.assertEquals((Object)"somechat", map.get("serviceName"));
        map = URISupport.parseQuery((String)"password=RAW(++?w0rd)&serviceName=somechat");
        URISupportTest.assertEquals((int)2, (int)map.size());
        URISupportTest.assertEquals((Object)"RAW(++?w0rd)", map.get("password"));
        URISupportTest.assertEquals((Object)"somechat", map.get("serviceName"));
        map = URISupport.parseQuery((String)"password=RAW(++?)w&rd)&serviceName=somechat");
        URISupportTest.assertEquals((int)2, (int)map.size());
        URISupportTest.assertEquals((Object)"RAW(++?)w&rd)", map.get("password"));
        URISupportTest.assertEquals((Object)"somechat", map.get("serviceName"));
    }

    public void testResolveRawParameterValues() throws Exception {
        Map map = URISupport.parseQuery((String)"password=secret&serviceName=somechat");
        URISupport.resolveRawParameterValues((Map)map);
        URISupportTest.assertEquals((int)2, (int)map.size());
        URISupportTest.assertEquals((Object)"secret", map.get("password"));
        URISupportTest.assertEquals((Object)"somechat", map.get("serviceName"));
        map = URISupport.parseQuery((String)"password=RAW(++?w0rd)&serviceName=somechat");
        URISupport.resolveRawParameterValues((Map)map);
        URISupportTest.assertEquals((int)2, (int)map.size());
        URISupportTest.assertEquals((Object)"++?w0rd", map.get("password"));
        URISupportTest.assertEquals((Object)"somechat", map.get("serviceName"));
        map = URISupport.parseQuery((String)"password=RAW(++?)w&rd)&serviceName=somechat");
        URISupport.resolveRawParameterValues((Map)map);
        URISupportTest.assertEquals((int)2, (int)map.size());
        URISupportTest.assertEquals((Object)"++?)w&rd", map.get("password"));
        URISupportTest.assertEquals((Object)"somechat", map.get("serviceName"));
    }
}

