/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.toolbox;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.toolbox.AggregationStrategies;
import org.apache.camel.util.toolbox.FlexibleAggregationStrategy;
import org.junit.Test;
import org.w3c.dom.Node;

public class FlexibleAggregationStrategiesTest
extends ContextTestSupport {
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final CountDownLatch timeoutLatch = new CountDownLatch(1);

    @Test
    public void testFlexibleAggregationStrategyNoCondition() throws Exception {
        this.getMockEndpoint("mock:result1").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result1").message(0).body()).isInstanceOf(ArrayList.class);
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE1", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE2", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE3", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE4", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE5", "id", (Object)"123");
        this.assertMockEndpointsSatisfied();
        List resultList = (List)((Exchange)this.getMockEndpoint("mock:result1").getReceivedExchanges().get(0)).getIn().getBody(List.class);
        for (int i = 0; i < 5; ++i) {
            FlexibleAggregationStrategiesTest.assertEquals((String)("AGGREGATE" + (i + 1)), (String)((String)resultList.get(i)));
        }
    }

    @Test
    public void testFlexibleAggregationStrategyCondition() throws Exception {
        this.getMockEndpoint("mock:result1").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result1").message(0).body()).isInstanceOf(ArrayList.class);
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE1", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"DISCARD", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE2", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"DISCARD", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE3", "id", (Object)"123");
        this.assertMockEndpointsSatisfied();
        List resultList = (List)((Exchange)this.getMockEndpoint("mock:result1").getReceivedExchanges().get(0)).getIn().getBody(List.class);
        for (int i = 0; i < 3; ++i) {
            FlexibleAggregationStrategiesTest.assertEquals((String)("AGGREGATE" + (i + 1)), (String)((String)resultList.get(i)));
        }
    }

    @Test
    public void testFlexibleAggregationStrategyStoreInPropertyHashSet() throws Exception {
        this.getMockEndpoint("mock:result2").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result2").message(0).property("AggregationResult")).isInstanceOf(HashSet.class);
        this.template.sendBodyAndHeader("direct:start2", (Object)"ignored body", "input", (Object)"AGGREGATE1");
        this.template.sendBodyAndHeader("direct:start2", (Object)"ignored body", "input", (Object)"DISCARD");
        this.template.sendBodyAndHeader("direct:start2", (Object)"ignored body", "input", (Object)"AGGREGATE2");
        this.template.sendBodyAndHeader("direct:start2", (Object)"ignored body", "input", (Object)"DISCARD");
        this.template.sendBodyAndHeader("direct:start2", (Object)"ignored body", "input", (Object)"AGGREGATE3");
        this.assertMockEndpointsSatisfied();
        HashSet resultSet = (HashSet)((Exchange)this.getMockEndpoint("mock:result2").getReceivedExchanges().get(0)).getProperty("AggregationResult", HashSet.class);
        FlexibleAggregationStrategiesTest.assertEquals((int)3, (int)resultSet.size());
        FlexibleAggregationStrategiesTest.assertTrue((resultSet.contains("AGGREGATE1") && resultSet.contains("AGGREGATE2") && resultSet.contains("AGGREGATE3") ? 1 : 0) != 0);
    }

    @Test
    public void testFlexibleAggregationStrategyStoreInHeaderSingleValue() throws Exception {
        this.getMockEndpoint("mock:result3").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result3").message(0).header("AggregationResult")).isInstanceOf(String.class);
        ((ValueBuilder)this.getMockEndpoint("mock:result3").message(0).header("AggregationResult")).isEqualTo((Object)"AGGREGATE3");
        this.template.sendBody("direct:start3", (Object)"AGGREGATE1");
        this.template.sendBody("direct:start3", (Object)"AGGREGATE2");
        this.template.sendBody("direct:start3", (Object)"AGGREGATE3");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFlexibleAggregationStrategyGenericArrayListWithoutNulls() throws Exception {
        this.getMockEndpoint("mock:result4").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result4").message(0).body()).isInstanceOf(ArrayList.class);
        this.template.sendBody("direct:start4", (Object)"AGGREGATE1");
        this.template.sendBody("direct:start4", (Object)123.0);
        this.template.sendBody("direct:start4", null);
        this.assertMockEndpointsSatisfied();
        ArrayList list = (ArrayList)((Exchange)this.getMockEndpoint("mock:result4").getReceivedExchanges().get(0)).getIn().getBody(ArrayList.class);
        FlexibleAggregationStrategiesTest.assertEquals((int)2, (int)list.size());
        FlexibleAggregationStrategiesTest.assertTrue((boolean)list.contains("AGGREGATE1"));
        FlexibleAggregationStrategiesTest.assertTrue((boolean)list.contains(123.0));
    }

    @Test
    public void testFlexibleAggregationStrategyFailWithInvalidCast() throws Exception {
        this.getMockEndpoint("mock:result5").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start5", (Object)"AGGREGATE1");
        }
        catch (Exception exception) {
            this.assertMockEndpointsSatisfied();
            return;
        }
        FlexibleAggregationStrategiesTest.fail((String)"Type Conversion exception expected, as we are not ignoring invalid casts");
    }

    @Test
    public void testFlexibleAggregationStrategyFailOnInvalidCast() throws Exception {
        this.getMockEndpoint("mock:result6").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result6").message(0).body()).isInstanceOf(ArrayList.class);
        this.template.sendBody("direct:start6", (Object)"AGGREGATE1");
        this.template.sendBody("direct:start6", (Object)"AGGREGATE2");
        this.template.sendBody("direct:start6", (Object)"AGGREGATE3");
        ArrayList list = (ArrayList)((Exchange)this.getMockEndpoint("mock:result6").getReceivedExchanges().get(0)).getIn().getBody(ArrayList.class);
        FlexibleAggregationStrategiesTest.assertEquals((int)3, (int)list.size());
        for (Object object : list) {
            FlexibleAggregationStrategiesTest.assertNull(object);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFlexibleAggregationStrategyTimeoutCompletionMixins() throws Exception {
        this.getMockEndpoint("mock:result.timeoutAndCompletionAware").expectedMessageCount(2);
        ((ValueBuilder)this.getMockEndpoint("mock:result.timeoutAndCompletionAware").message(0).body()).isEqualTo((Object)"AGGREGATE1");
        ((ValueBuilder)this.getMockEndpoint("mock:result.timeoutAndCompletionAware").message(0).property("Timeout")).isEqualTo((Object)true);
        ((ValueBuilder)this.getMockEndpoint("mock:result.timeoutAndCompletionAware").message(1).body()).isEqualTo((Object)"AGGREGATE3");
        this.template.sendBody("direct:start.timeoutAndCompletionAware", (Object)"AGGREGATE1");
        FlexibleAggregationStrategiesTest.assertTrue((boolean)this.timeoutLatch.await(2500L, TimeUnit.MILLISECONDS));
        this.template.sendBody("direct:start.timeoutAndCompletionAware", (Object)"AGGREGATE2");
        this.template.sendBody("direct:start.timeoutAndCompletionAware", (Object)"AGGREGATE3");
        FlexibleAggregationStrategiesTest.assertTrue((boolean)this.completionLatch.await(2500L, TimeUnit.MILLISECONDS));
        this.getMockEndpoint("mock:result.timeoutAndCompletionAware").getReceivedExchanges();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFlexibleAggregationStrategyPickXPath() throws Exception {
        this.getMockEndpoint("mock:result.xpath1").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:result.xpath1").message(0).body()).isInstanceOf(ArrayList.class);
        this.template.sendBody("direct:start.xpath1", (Object)"<envelope><result>ok</result></envelope>");
        this.template.sendBody("direct:start.xpath1", (Object)"<envelope><result>error</result></envelope>");
        this.template.sendBody("direct:start.xpath1", (Object)"<envelope>no result</envelope>");
        this.assertMockEndpointsSatisfied();
        ArrayList list = (ArrayList)((Exchange)this.getMockEndpoint("mock:result.xpath1").getReceivedExchanges().get(0)).getIn().getBody(ArrayList.class);
        FlexibleAggregationStrategiesTest.assertEquals((int)2, (int)list.size());
        FlexibleAggregationStrategiesTest.assertEquals((String)"ok", (String)((Node)list.get(0)).getTextContent());
        FlexibleAggregationStrategiesTest.assertEquals((String)"error", (String)((Node)list.get(1)).getTextContent());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((AggregateDefinition)this.from("direct:start1").aggregate((AggregationStrategy)AggregationStrategies.flexible(String.class).accumulateInCollection(ArrayList.class).pick((Expression)this.simple("${body}")).condition((Predicate)this.simple("${body} contains 'AGGREGATE'"))).header("id")).completionSize(5).to("mock:result1");
                ((AggregateDefinition)this.from("direct:start2").aggregate((AggregationStrategy)AggregationStrategies.flexible(String.class).accumulateInCollection(HashSet.class).pick((Expression)this.simple("${header.input}")).condition((Predicate)this.simple("${header.input} contains 'AGGREGATE'")).storeInProperty("AggregationResult")).constant((Object)true)).completionSize(5).to("mock:result2");
                ((AggregateDefinition)this.from("direct:start3").aggregate((AggregationStrategy)AggregationStrategies.flexible(String.class).storeInHeader("AggregationResult")).constant((Object)true)).completionSize(3).to("mock:result3");
                ((AggregateDefinition)this.from("direct:start4").aggregate((AggregationStrategy)AggregationStrategies.flexible().accumulateInCollection(ArrayList.class)).constant((Object)true)).completionSize(3).to("mock:result4");
                ((AggregateDefinition)this.from("direct:start5").aggregate((AggregationStrategy)AggregationStrategies.flexible(Integer.class).accumulateInCollection(ArrayList.class)).constant((Object)true)).completionSize(3).to("mock:result5");
                ((AggregateDefinition)this.from("direct:start6").aggregate((AggregationStrategy)AggregationStrategies.flexible(Integer.class).ignoreInvalidCasts().storeNulls().accumulateInCollection(ArrayList.class)).constant((Object)true)).completionSize(3).to("mock:result6");
                FlexibleAggregationStrategy timeoutCompletionStrategy = AggregationStrategies.flexible(String.class).condition((Predicate)this.simple("${body} contains 'AGGREGATE'")).timeoutAware(new FlexibleAggregationStrategy.TimeoutAwareMixin(){

                    public void timeout(Exchange exchange, int index, int total, long timeout) {
                        exchange.setProperty("Timeout", (Object)true);
                        FlexibleAggregationStrategiesTest.this.timeoutLatch.countDown();
                    }
                }).completionAware(new FlexibleAggregationStrategy.CompletionAwareMixin(){

                    public void onCompletion(Exchange exchange) {
                        FlexibleAggregationStrategiesTest.this.completionLatch.countDown();
                    }
                });
                ((AggregateDefinition)this.from("direct:start.timeoutAndCompletionAware").aggregate((AggregationStrategy)timeoutCompletionStrategy).constant((Object)true)).completionTimeout(500L).completionSize(2).to("mock:result.timeoutAndCompletionAware");
                ((AggregateDefinition)this.from("direct:start.xpath1").aggregate((AggregationStrategy)AggregationStrategies.flexible(Node.class).pick((Expression)this.xpath("//result[1]").nodeResult()).accumulateInCollection(ArrayList.class)).constant((Object)true)).completionSize(3).to("mock:result.xpath1");
            }
        };
    }
}

