/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.GZIPHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;

@Converter
public final class HttpEntityConverter {
    private HttpEntityConverter() {
    }

    @Converter
    public static HttpEntity toHttpEntity(byte[] data, Exchange exchange) throws Exception {
        return HttpEntityConverter.asHttpEntity(data, exchange);
    }

    @Converter
    public static HttpEntity toHttpEntity(InputStream inStream, Exchange exchange) throws Exception {
        return HttpEntityConverter.asHttpEntity(inStream, exchange);
    }

    @Converter
    public static HttpEntity toHttpEntity(String str, Exchange exchange) throws Exception {
        if (exchange != null && GZIPHelper.isGzip((Message)exchange.getIn())) {
            byte[] data = (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, (Object)str);
            return HttpEntityConverter.asHttpEntity(data, exchange);
        }
        return null;
    }

    private static HttpEntity asHttpEntity(InputStream in, Exchange exchange) throws IOException {
        Message inMessage;
        String length;
        String contentEncoding;
        InputStream stream;
        InputStreamEntity entity = !((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue() ? new InputStreamEntity(stream, (stream = GZIPHelper.compressGzip((String)(contentEncoding = (String)exchange.getIn().getHeader("Content-Encoding", String.class)), (InputStream)in)) instanceof ByteArrayInputStream ? (stream.available() != 0 ? (long)stream.available() : -1L) : -1L) : (ObjectHelper.isEmpty((Object)(length = (String)(inMessage = exchange.getIn()).getHeader("Content-Length", String.class))) ? new InputStreamEntity(in, -1L) : new InputStreamEntity(in, Long.parseLong(length)));
        if (exchange != null) {
            contentEncoding = (String)exchange.getIn().getHeader("Content-Encoding", String.class);
            String contentType = ExchangeHelper.getContentType((Exchange)exchange);
            entity.setContentEncoding(contentEncoding);
            entity.setContentType(contentType);
        }
        return entity;
    }

    private static HttpEntity asHttpEntity(byte[] data, Exchange exchange) throws Exception {
        String contentEncoding;
        InputStream stream;
        InputStreamEntity entity = exchange != null && !((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue() ? new InputStreamEntity(stream, (stream = GZIPHelper.compressGzip((String)(contentEncoding = (String)exchange.getIn().getHeader("Content-Encoding", String.class)), (byte[])data)) instanceof ByteArrayInputStream ? (stream.available() != 0 ? (long)stream.available() : -1L) : -1L) : new InputStreamEntity((InputStream)new ByteArrayInputStream(data), (long)data.length);
        if (exchange != null) {
            contentEncoding = (String)exchange.getIn().getHeader("Content-Encoding", String.class);
            String contentType = ExchangeHelper.getContentType((Exchange)exchange);
            entity.setContentEncoding(contentEncoding);
            entity.setContentType(contentType);
        }
        return entity;
    }
}

