/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.printer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.attribute.DocAttributeSet;

class PrintDocument
implements Doc {
    private DocFlavor docFlavor;
    private InputStream stream;
    private Reader reader;
    private byte[] buffer;

    public PrintDocument(InputStream stream, DocFlavor docFlavor) {
        this.stream = stream;
        this.docFlavor = docFlavor;
    }

    @Override
    public DocFlavor getDocFlavor() {
        return this.docFlavor;
    }

    @Override
    public DocAttributeSet getAttributes() {
        return null;
    }

    @Override
    public Object getPrintData() throws IOException {
        return this.getStreamForBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getReaderForText() throws IOException {
        PrintDocument printDocument = this;
        synchronized (printDocument) {
            if (this.reader != null) {
                return this.reader;
            }
            if (this.docFlavor.getMediaType().equalsIgnoreCase("image")) {
                this.reader = null;
            } else if (this.docFlavor.getMediaType().equalsIgnoreCase("text") || this.docFlavor.getMediaType().equalsIgnoreCase("application") && this.docFlavor.getMediaSubtype().equalsIgnoreCase("xml")) {
                this.buffer = new byte[this.stream.available()];
                int n = this.stream.available();
                for (int i = 0; i < n; ++i) {
                    this.buffer[i] = (byte)this.stream.read();
                }
                this.reader = new StringReader(new String(this.buffer));
                this.stream = new ByteArrayInputStream(this.buffer);
            }
            return this.reader;
        }
    }

    @Override
    public InputStream getStreamForBytes() throws IOException {
        return this.stream;
    }
}

