/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import java.net.URI;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.avro.AvroComponent;
import org.apache.commons.lang.StringUtils;

public class AvroConfiguration
implements Cloneable {
    private String host;
    private int port;
    private Protocol protocol;
    private String protocolLocation;
    private String protocolClassName;
    private String transport;
    private String messageName;
    private String uriAuthority;
    private boolean reflectionProtocol;
    private boolean singleParameter;

    public AvroConfiguration copy() {
        try {
            AvroConfiguration answer = (AvroConfiguration)this.clone();
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void parseURI(URI uri, Map<String, Object> parameters, AvroComponent component) throws Exception {
        this.transport = uri.getScheme();
        if (!"http".equalsIgnoreCase(this.transport) && !"netty".equalsIgnoreCase(this.transport)) {
            throw new IllegalArgumentException("Unrecognized Avro IPC transport: " + this.protocol + " for uri: " + uri);
        }
        this.setHost(uri.getHost());
        this.setPort(uri.getPort());
        if (uri.getPath() != null && StringUtils.indexOf((String)uri.getPath(), (String)"/") != -1) {
            String path = StringUtils.substringAfter((String)uri.getPath(), (String)"/");
            if (!path.contains("/")) {
                this.setMessageName(path);
            } else {
                throw new IllegalArgumentException("Unrecognized Avro message name: " + path + " for uri: " + uri);
            }
        }
        this.setUriAuthority(uri.getAuthority());
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public String getProtocolLocation() {
        return this.protocolLocation;
    }

    public void setProtocolLocation(String protocolLocation) {
        this.protocolLocation = protocolLocation;
    }

    public String getProtocolClassName() {
        return this.protocolClassName;
    }

    public void setProtocolClassName(String protocolClassName) {
        this.protocolClassName = protocolClassName;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    public String getUriAuthority() {
        return this.uriAuthority;
    }

    public void setUriAuthority(String uriAuthority) {
        this.uriAuthority = uriAuthority;
    }

    public boolean isReflectionProtocol() {
        return this.reflectionProtocol;
    }

    public void setReflectionProtocol(boolean isReflectionProtocol) {
        this.reflectionProtocol = isReflectionProtocol;
    }

    public boolean isSingleParameter() {
        return this.singleParameter;
    }

    public void setSingleParameter(boolean singleParameter) {
        this.singleParameter = singleParameter;
    }
}

