/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ManagementAgent;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.util.StringEscapeUtils;

@Command(scope="camel", name="route-info", description="Display information about a Camel route.")
public class RouteInfo
extends OsgiCommandSupport {
    @Argument(index=0, name="route", description="The Camel route ID.", required=true, multiValued=false)
    String route;
    @Argument(index=1, name="context", description="The Camel context name.", required=false, multiValued=false)
    String context;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    public Object doExecute() throws Exception {
        Route camelRoute = this.camelController.getRoute(this.route, this.context);
        if (camelRoute == null) {
            System.err.println("Camel route " + this.route + " not found.");
            return null;
        }
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1m\u001b[33mCamel Route " + camelRoute.getId() + "\u001b[0m"));
        System.out.println(StringEscapeUtils.unescapeJava("\tCamel Context: " + camelRoute.getRouteContext().getCamelContext().getName()));
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mProperties\u001b[0m"));
        for (String property : camelRoute.getProperties().keySet()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t\t" + property + " = " + camelRoute.getProperties().get(property)));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mStatistics\u001b[0m"));
        CamelContext camelContext = camelRoute.getRouteContext().getCamelContext();
        if (camelContext != null) {
            ManagementAgent agent = camelContext.getManagementStrategy().getManagementAgent();
            if (agent != null) {
                ObjectName routeMBean;
                String camelId;
                MBeanServer mBeanServer = agent.getMBeanServer();
                Set<ObjectName> set = mBeanServer.queryNames(new ObjectName(agent.getMBeanObjectDomainName() + ":type=routes,name=\"" + this.route + "\",*"), null);
                Iterator<ObjectName> iterator = set.iterator();
                if (iterator.hasNext() && (camelId = (String)mBeanServer.getAttribute(routeMBean = iterator.next(), "CamelId")) != null && camelId.equals(camelContext.getName())) {
                    Integer inflightExchange = (Integer)mBeanServer.getAttribute(routeMBean, "InflightExchanges");
                    System.out.println(StringEscapeUtils.unescapeJava("\tInflight Exchanges: " + inflightExchange));
                    Long exchangesTotal = (Long)mBeanServer.getAttribute(routeMBean, "ExchangesTotal");
                    System.out.println(StringEscapeUtils.unescapeJava("\tExchanges Total: " + exchangesTotal));
                    Long exchangesCompleted = (Long)mBeanServer.getAttribute(routeMBean, "ExchangesCompleted");
                    System.out.println(StringEscapeUtils.unescapeJava("\tExchanges Completed: " + exchangesCompleted));
                    Long exchangesFailed = (Long)mBeanServer.getAttribute(routeMBean, "ExchangesFailed");
                    System.out.println(StringEscapeUtils.unescapeJava("\tExchanges Failed: " + exchangesFailed));
                    Long minProcessingTime = (Long)mBeanServer.getAttribute(routeMBean, "MinProcessingTime");
                    System.out.println(StringEscapeUtils.unescapeJava("\tMin Processing Time: " + minProcessingTime + " ms"));
                    Long maxProcessingTime = (Long)mBeanServer.getAttribute(routeMBean, "MaxProcessingTime");
                    System.out.println(StringEscapeUtils.unescapeJava("\tMax Processing Time: " + maxProcessingTime + " ms"));
                    Long meanProcessingTime = (Long)mBeanServer.getAttribute(routeMBean, "MeanProcessingTime");
                    System.out.println(StringEscapeUtils.unescapeJava("\tMean Processing Time: " + meanProcessingTime + " ms"));
                    Long totalProcessingTime = (Long)mBeanServer.getAttribute(routeMBean, "TotalProcessingTime");
                    System.out.println(StringEscapeUtils.unescapeJava("\tTotal Processing Time: " + totalProcessingTime + " ms"));
                    Long lastProcessingTime = (Long)mBeanServer.getAttribute(routeMBean, "LastProcessingTime");
                    System.out.println(StringEscapeUtils.unescapeJava("\tLast Processing Time: " + lastProcessingTime + " ms"));
                    Long deltaProcessingTime = (Long)mBeanServer.getAttribute(routeMBean, "DeltaProcessingTime");
                    System.out.println(StringEscapeUtils.unescapeJava("\tDelta Processing Time: " + deltaProcessingTime + " ms"));
                    String load01 = (String)mBeanServer.getAttribute(routeMBean, "Load01");
                    String load05 = (String)mBeanServer.getAttribute(routeMBean, "Load05");
                    String load15 = (String)mBeanServer.getAttribute(routeMBean, "Load15");
                    System.out.println(StringEscapeUtils.unescapeJava("\tLoad Avg: " + load01 + ", " + load05 + ", " + load15));
                    Object resetTimestampObj = mBeanServer.getAttribute(routeMBean, "ResetTimestamp");
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    if (resetTimestampObj == null) {
                        System.out.println(StringEscapeUtils.unescapeJava("\tReset Statistics Date:"));
                    } else {
                        Date firstExchangeTimestamp = (Date)resetTimestampObj;
                        System.out.println(StringEscapeUtils.unescapeJava("\tReset Statistics Date: " + format.format(firstExchangeTimestamp)));
                    }
                    Object firstExchangeTimestampObj = mBeanServer.getAttribute(routeMBean, "FirstExchangeCompletedTimestamp");
                    if (firstExchangeTimestampObj == null) {
                        System.out.println(StringEscapeUtils.unescapeJava("\tFirst Exchange Date:"));
                    } else {
                        Date firstExchangeTimestamp = (Date)firstExchangeTimestampObj;
                        System.out.println(StringEscapeUtils.unescapeJava("\tFirst Exchange Date: " + format.format(firstExchangeTimestamp)));
                    }
                    Object lastExchangeCompletedTimestampObj = mBeanServer.getAttribute(routeMBean, "LastExchangeCompletedTimestamp");
                    if (lastExchangeCompletedTimestampObj == null) {
                        System.out.println(StringEscapeUtils.unescapeJava("\tLast Exchange Completed Date:"));
                    } else {
                        Date lastExchangeCompletedTimestamp = (Date)lastExchangeCompletedTimestampObj;
                        System.out.println(StringEscapeUtils.unescapeJava("\tLast Exchange Completed Date: " + format.format(lastExchangeCompletedTimestamp)));
                    }
                }
            } else {
                System.out.println("");
                System.out.println(StringEscapeUtils.unescapeJava("\u001b[31mJMX Agent of Camel is not reachable. Maybe it has been disabled on the Camel context"));
                System.out.println(StringEscapeUtils.unescapeJava("In consequence, some statistics are not available.\u001b[0m"));
            }
            System.out.println("");
            System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mDefinition\u001b[0m"));
            RouteDefinition definition = this.camelController.getRouteDefinition(this.route, camelRoute.getRouteContext().getCamelContext().getName());
            System.out.println(StringEscapeUtils.unescapeJava(ModelHelper.dumpModelAsXml((NamedNode)definition)));
        }
        return null;
    }
}

