/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mybatis;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mybatis.MyBatisEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class MyBatisComponent
extends DefaultComponent {
    private SqlSessionFactory sqlSessionFactory;
    private String configurationUri = "SqlMapConfig.xml";

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MyBatisEndpoint answer = new MyBatisEndpoint(uri, (Component)this, remaining);
        this.setProperties((Object)answer, parameters);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SqlSessionFactory createSqlSessionFactory() throws IOException {
        ObjectHelper.notNull((Object)this.configurationUri, (String)"configurationUri", (Object)((Object)this));
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.getCamelContext().getClassResolver(), (String)this.configurationUri);
        try {
            SqlSessionFactory sqlSessionFactory = new SqlSessionFactoryBuilder().build(is);
            return sqlSessionFactory;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public String getConfigurationUri() {
        return this.configurationUri;
    }

    public void setConfigurationUri(String configurationUri) {
        this.configurationUri = configurationUri;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.sqlSessionFactory == null) {
            this.sqlSessionFactory = this.createSqlSessionFactory();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
    }
}

