/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.RedisClient;
import org.apache.camel.component.redis.RedisConfiguration;

public class CommandDispatcher {
    private final RedisConfiguration configuration;
    private final Exchange exchange;

    public CommandDispatcher(RedisConfiguration configuration, Exchange exchange) {
        this.configuration = configuration;
        this.exchange = exchange;
    }

    public void execute(RedisClient redisClient) {
        switch (this.determineCommand()) {
            case PING: {
                this.setResult(redisClient.ping());
                break;
            }
            case SET: {
                redisClient.set(this.getKey(), this.getValue());
                break;
            }
            case GET: {
                this.setResult(redisClient.get(this.getKey()));
                break;
            }
            case QUIT: {
                redisClient.quit();
                break;
            }
            case EXISTS: {
                this.setResult(redisClient.exists(this.getKey()));
                break;
            }
            case DEL: {
                redisClient.del(this.getKeys());
                break;
            }
            case TYPE: {
                this.setResult(redisClient.type(this.getKey()));
                break;
            }
            case KEYS: {
                this.setResult(redisClient.keys(this.getPattern()));
                break;
            }
            case RANDOMKEY: {
                this.setResult(redisClient.randomkey());
                break;
            }
            case RENAME: {
                redisClient.rename(this.getKey(), this.getStringValue());
                break;
            }
            case RENAMENX: {
                this.setResult(redisClient.renamenx(this.getKey(), this.getStringValue()));
                break;
            }
            case EXPIRE: {
                this.setResult(redisClient.expire(this.getKey(), this.getTimeout()));
                break;
            }
            case EXPIREAT: {
                this.setResult(redisClient.expireat(this.getKey(), this.getTimestamp()));
                break;
            }
            case PEXPIRE: {
                this.setResult(redisClient.pexpire(this.getKey(), this.getTimeout()));
                break;
            }
            case PEXPIREAT: {
                this.setResult(redisClient.pexpireat(this.getKey(), this.getTimestamp()));
                break;
            }
            case TTL: {
                this.setResult(redisClient.ttl(this.getKey()));
                break;
            }
            case MOVE: {
                this.setResult(redisClient.move(this.getKey(), this.getDb()));
                break;
            }
            case GETSET: {
                this.setResult(redisClient.getset(this.getKey(), this.getValue()));
                break;
            }
            case MGET: {
                this.setResult(redisClient.mget(this.getFields()));
                break;
            }
            case SETNX: {
                this.setResult(redisClient.setnx(this.getKey(), this.getValue()));
                break;
            }
            case SETEX: {
                redisClient.setex(this.getKey(), this.getValue(), this.getTimeout(), TimeUnit.SECONDS);
                break;
            }
            case MSET: {
                redisClient.mset(this.getValuesAsMap());
                break;
            }
            case MSETNX: {
                redisClient.msetnx(this.getValuesAsMap());
                break;
            }
            case DECRBY: {
                this.setResult(redisClient.decrby(this.getKey(), this.getLongValue()));
                break;
            }
            case DECR: {
                this.setResult(redisClient.decr(this.getKey()));
                break;
            }
            case INCRBY: {
                this.setResult(redisClient.incrby(this.getKey(), this.getLongValue()));
                break;
            }
            case INCR: {
                this.setResult(redisClient.incr(this.getKey()));
                break;
            }
            case APPEND: {
                this.setResult(redisClient.append(this.getKey(), this.getStringValue()));
                break;
            }
            case HSET: {
                redisClient.hset(this.getKey(), this.getField(), this.getValue());
                break;
            }
            case HGET: {
                this.setResult(redisClient.hget(this.getKey(), this.getField()));
                break;
            }
            case HSETNX: {
                this.setResult(redisClient.hsetnx(this.getKey(), this.getField(), this.getValue()));
                break;
            }
            case HMSET: {
                redisClient.hmset(this.getKey(), this.getValuesAsMap());
                break;
            }
            case HMGET: {
                this.setResult(redisClient.hmget(this.getKey(), this.getFields()));
                break;
            }
            case HINCRBY: {
                this.setResult(redisClient.hincrBy(this.getKey(), this.getField(), this.getValueAsLong()));
                break;
            }
            case HEXISTS: {
                this.setResult(redisClient.hexists(this.getKey(), this.getField()));
                break;
            }
            case HDEL: {
                redisClient.hdel(this.getKey(), this.getField());
                break;
            }
            case HLEN: {
                this.setResult(redisClient.hlen(this.getKey()));
                break;
            }
            case HKEYS: {
                this.setResult(redisClient.hkeys(this.getKey()));
                break;
            }
            case HVALS: {
                this.setResult(redisClient.hvals(this.getKey()));
                break;
            }
            case HGETALL: {
                this.setResult(redisClient.hgetAll(this.getKey()));
                break;
            }
            case RPUSH: {
                this.setResult(redisClient.rpush(this.getKey(), this.getValue()));
                break;
            }
            case LPUSH: {
                this.setResult(redisClient.lpush(this.getKey(), this.getValue()));
                break;
            }
            case LLEN: {
                this.setResult(redisClient.llen(this.getKey()));
                break;
            }
            case LRANGE: {
                this.setResult(redisClient.lrange(this.getKey(), this.getStart(), this.getEnd()));
                break;
            }
            case LTRIM: {
                redisClient.ltrim(this.getKey(), this.getStart(), this.getEnd());
                break;
            }
            case LINDEX: {
                this.setResult(redisClient.lindex(this.getKey(), this.getIndex()));
                break;
            }
            case LSET: {
                redisClient.lset(this.getKey(), this.getValue(), this.getIndex());
                break;
            }
            case LREM: {
                this.setResult(redisClient.lrem(this.getKey(), this.getValue(), this.getCount()));
                break;
            }
            case LPOP: {
                this.setResult(redisClient.lpop(this.getKey()));
                break;
            }
            case RPOP: {
                this.setResult(redisClient.rpop(this.getKey()));
                break;
            }
            case RPOPLPUSH: {
                this.setResult(redisClient.rpoplpush(this.getKey(), this.getDestination()));
                break;
            }
            case SADD: {
                this.setResult(redisClient.sadd(this.getKey(), this.getValue()));
                break;
            }
            case SMEMBERS: {
                this.setResult(redisClient.smembers(this.getKey()));
                break;
            }
            case SREM: {
                this.setResult(redisClient.srem(this.getKey(), this.getValue()));
                break;
            }
            case SPOP: {
                this.setResult(redisClient.spop(this.getKey()));
                break;
            }
            case SMOVE: {
                this.setResult(redisClient.smove(this.getKey(), this.getValue(), this.getDestination()));
                break;
            }
            case SCARD: {
                this.setResult(redisClient.scard(this.getKey()));
                break;
            }
            case SISMEMBER: {
                this.setResult(redisClient.sismember(this.getKey(), this.getValue()));
                break;
            }
            case SINTER: {
                this.setResult(redisClient.sinter(this.getKey(), this.getKeys()));
                break;
            }
            case SINTERSTORE: {
                redisClient.sinterstore(this.getKey(), this.getKeys(), this.getDestination());
                break;
            }
            case SUNION: {
                this.setResult(redisClient.sunion(this.getKey(), this.getKeys()));
                break;
            }
            case SUNIONSTORE: {
                redisClient.sunionstore(this.getKey(), this.getKeys(), this.getDestination());
                break;
            }
            case SDIFF: {
                this.setResult(redisClient.sdiff(this.getKey(), this.getKeys()));
                break;
            }
            case SDIFFSTORE: {
                redisClient.sdiffstore(this.getKey(), this.getKeys(), this.getDestination());
                break;
            }
            case SRANDMEMBER: {
                this.setResult(redisClient.srandmember(this.getKey()));
                break;
            }
            case ZADD: {
                this.setResult(redisClient.zadd(this.getKey(), this.getValue(), this.getScore()));
                break;
            }
            case ZRANGE: {
                this.setResult(redisClient.zrange(this.getKey(), this.getStart(), this.getEnd(), this.getWithScore()));
                break;
            }
            case ZREM: {
                this.setResult(redisClient.zrem(this.getKey(), this.getValue()));
                break;
            }
            case ZINCRBY: {
                this.setResult(redisClient.zincrby(this.getKey(), this.getValue(), this.getIncrement()));
                break;
            }
            case ZRANK: {
                this.setResult(redisClient.zrank(this.getKey(), this.getValue()));
                break;
            }
            case ZREVRANK: {
                this.setResult(redisClient.zrevrank(this.getKey(), this.getValue()));
                break;
            }
            case ZREVRANGE: {
                this.setResult(redisClient.zrevrange(this.getKey(), this.getStart(), this.getEnd(), this.getWithScore()));
                break;
            }
            case ZCARD: {
                this.setResult(redisClient.zcard(this.getKey()));
                break;
            }
            case MULTI: {
                redisClient.multi();
                break;
            }
            case DISCARD: {
                redisClient.discard();
                break;
            }
            case EXEC: {
                redisClient.exec();
                break;
            }
            case WATCH: {
                redisClient.watch(this.getKeys());
                break;
            }
            case UNWATCH: {
                redisClient.unwatch();
                break;
            }
            case SORT: {
                this.setResult(redisClient.sort(this.getKey()));
                break;
            }
            case BLPOP: {
                this.setResult(redisClient.blpop(this.getKey(), this.getTimeout()));
                break;
            }
            case BRPOP: {
                this.setResult(redisClient.brpop(this.getKey(), this.getTimeout()));
                break;
            }
            case PUBLISH: {
                redisClient.publish(this.getChannel(), this.getMessage());
                break;
            }
            case ZCOUNT: {
                this.setResult(redisClient.zcount(this.getKey(), this.getMin(), this.getMax()));
                break;
            }
            case ZRANGEBYSCORE: {
                this.setResult(redisClient.zrangebyscore(this.getKey(), this.getMin(), this.getMax()));
                break;
            }
            case ZREVRANGEBYSCORE: {
                this.setResult(redisClient.zrevrangebyscore(this.getKey(), this.getMin(), this.getMax()));
                break;
            }
            case ZREMRANGEBYRANK: {
                redisClient.zremrangebyrank(this.getKey(), this.getStart(), this.getEnd());
                break;
            }
            case ZREMRANGEBYSCORE: {
                redisClient.zremrangebyscore(this.getKey(), this.getStart(), this.getEnd());
                break;
            }
            case ZUNIONSTORE: {
                redisClient.zunionstore(this.getKey(), this.getKeys(), this.getDestination());
                break;
            }
            case ZINTERSTORE: {
                redisClient.zinterstore(this.getKey(), this.getKeys(), this.getDestination());
                break;
            }
            case STRLEN: {
                this.setResult(redisClient.strlen(this.getKey()));
                break;
            }
            case PERSIST: {
                this.setResult(redisClient.persist(this.getKey()));
                break;
            }
            case RPUSHX: {
                this.setResult(redisClient.rpushx(this.getKey(), this.getValue()));
                break;
            }
            case ECHO: {
                this.setResult(redisClient.echo(this.getStringValue()));
                break;
            }
            case LINSERT: {
                this.setResult(redisClient.linsert(this.getKey(), this.getValue(), this.getPivot(), this.getPosition()));
                break;
            }
            case BRPOPLPUSH: {
                this.setResult(redisClient.brpoplpush(this.getKey(), this.getDestination(), this.getTimeout()));
                break;
            }
            case SETBIT: {
                redisClient.setbit(this.getKey(), this.getOffset(), this.getBooleanValue());
                break;
            }
            case GETBIT: {
                this.setResult(redisClient.getbit(this.getKey(), this.getOffset()));
                break;
            }
            case SETRANGE: {
                redisClient.setex(this.getKey(), this.getValue(), this.getOffset());
                break;
            }
            case GETRANGE: {
                this.setResult(redisClient.getrange(this.getKey(), this.getStart(), this.getEnd()));
                break;
            }
            default: {
                throw new RuntimeExchangeException("Unsupported command", this.exchange);
            }
        }
    }

    private Command determineCommand() {
        String command = (String)this.exchange.getIn().getHeader("CamelRedis.Command", String.class);
        if (command == null) {
            command = this.configuration.getCommand();
        }
        if (command == null) {
            return Command.SET;
        }
        return Command.valueOf(command);
    }

    private static <T> T getInHeaderValue(Exchange exchange, String key, Class<T> aClass) {
        return (T)exchange.getIn().getHeader(key, aClass);
    }

    private void setResult(Object result) {
        Message message;
        if (this.exchange.getPattern().isOutCapable()) {
            message = this.exchange.getOut();
            message.copyFrom(this.exchange.getIn());
        } else {
            message = this.exchange.getIn();
        }
        message.setBody(result);
    }

    public String getDestination() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Destination", String.class);
    }

    private String getChannel() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Channel", String.class);
    }

    private Object getMessage() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Message", Object.class);
    }

    public Long getIndex() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Index", Long.class);
    }

    public String getPivot() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Pivot", String.class);
    }

    public String getPosition() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Position", String.class);
    }

    public Long getCount() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Count", Long.class);
    }

    private Long getStart() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Start", Long.class);
    }

    private Long getEnd() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.End", Long.class);
    }

    private Long getTimeout() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Timeout", Long.class);
    }

    private Long getOffset() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Offset", Long.class);
    }

    private Long getValueAsLong() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Value", Long.class);
    }

    private Collection<String> getFields() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Fields", Collection.class);
    }

    private Map<String, Object> getValuesAsMap() {
        return (Map)CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Values", new HashMap().getClass());
    }

    private String getKey() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Key", String.class);
    }

    public Collection<String> getKeys() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Keys", Collection.class);
    }

    private Object getValue() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Value", Object.class);
    }

    private String getStringValue() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Value", String.class);
    }

    private Long getLongValue() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Value", Long.class);
    }

    private Boolean getBooleanValue() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Value", Boolean.class);
    }

    private String getField() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Field", String.class);
    }

    public Long getTimestamp() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Timestamp", Long.class);
    }

    public String getPattern() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Pattern", String.class);
    }

    public Integer getDb() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Db", Integer.class);
    }

    public Double getScore() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Score", Double.class);
    }

    public Double getMin() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Min", Double.class);
    }

    public Double getMax() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Max", Double.class);
    }

    public Double getIncrement() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.Increment", Double.class);
    }

    public Boolean getWithScore() {
        return CommandDispatcher.getInHeaderValue(this.exchange, "CamelRedis.WithScore", Boolean.class);
    }
}

