/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.converter.crypto.PGPDataFormatUtil;
import org.apache.camel.converter.crypto.PGPPassphraseAccessor;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGPDataFormat
extends ServiceSupport
implements DataFormat {
    public static final String KEY_FILE_NAME = "CamelPGPDataFormatKeyFileName";
    public static final String ENCRYPTION_KEY_RING = "CamelPGPDataFormatEncryptionKeyRing";
    public static final String KEY_USERID = "CamelPGPDataFormatKeyUserid";
    public static final String KEY_USERIDS = "CamelPGPDataFormatKeyUserids";
    public static final String KEY_PASSWORD = "CamelPGPDataFormatKeyPassword";
    public static final String SIGNATURE_KEY_FILE_NAME = "CamelPGPDataFormatSignatureKeyFileName";
    public static final String SIGNATURE_KEY_RING = "CamelPGPDataFormatSignatureKeyRing";
    public static final String SIGNATURE_KEY_USERID = "CamelPGPDataFormatSignatureKeyUserid";
    public static final String SIGNATURE_KEY_USERIDS = "CamelPGPDataFormatSignatureKeyUserids";
    public static final String SIGNATURE_KEY_PASSWORD = "CamelPGPDataFormatSignatureKeyPassword";
    public static final String ENCRYPTION_ALGORITHM = "CamelPGPDataFormatEncryptionAlgorithm";
    public static final String SIGNATURE_HASH_ALGORITHM = "CamelPGPDataFormatSignatureHashAlgorithm";
    public static final String COMPRESSION_ALGORITHM = "CamelPGPDataFormatCompressionAlgorithm";
    public static final String NUMBER_OF_ENCRYPTION_KEYS = "CamelPGPDataFormatNumberOfEncryptionKeys";
    public static final String NUMBER_OF_SIGNING_KEYS = "CamelPGPDataFormatNumberOfSigningKeys";
    private static final Logger LOG = LoggerFactory.getLogger(PGPDataFormat.class);
    private static final String BC = "BC";
    private static final int BUFFER_SIZE = 16384;
    private String provider = "BC";
    private String keyUserid;
    private List<String> keyUserids;
    private String password;
    private String keyFileName;
    private byte[] encryptionKeyRing;
    private String signatureKeyUserid;
    private List<String> signatureKeyUserids;
    private String signaturePassword;
    private String signatureKeyFileName;
    private byte[] signatureKeyRing;
    private boolean armored;
    private boolean integrity = true;
    private int hashAlgorithm = 2;
    private int algorithm = 3;
    private int compressionAlgorithm = 1;
    private PGPPassphraseAccessor passphraseAccessor;

    protected String findKeyFileName(Exchange exchange) {
        return (String)exchange.getIn().getHeader(KEY_FILE_NAME, (Object)this.getKeyFileName(), String.class);
    }

    protected byte[] findEncryptionKeyRing(Exchange exchange) {
        return (byte[])exchange.getIn().getHeader(ENCRYPTION_KEY_RING, (Object)this.getEncryptionKeyRing(), byte[].class);
    }

    protected String findKeyUserid(Exchange exchange) {
        return (String)exchange.getIn().getHeader(KEY_USERID, (Object)this.getKeyUserid(), String.class);
    }

    protected List<String> findKeyUserids(Exchange exchange) {
        return (List)exchange.getIn().getHeader(KEY_USERIDS, this.getKeyUserids(), List.class);
    }

    protected String findKeyPassword(Exchange exchange) {
        return (String)exchange.getIn().getHeader(KEY_PASSWORD, (Object)this.getPassword(), String.class);
    }

    protected String findSignatureKeyFileName(Exchange exchange) {
        return (String)exchange.getIn().getHeader(SIGNATURE_KEY_FILE_NAME, (Object)this.getSignatureKeyFileName(), String.class);
    }

    protected byte[] findSignatureKeyRing(Exchange exchange) {
        return (byte[])exchange.getIn().getHeader(SIGNATURE_KEY_RING, (Object)this.getSignatureKeyRing(), byte[].class);
    }

    protected String findSignatureKeyUserid(Exchange exchange) {
        return (String)exchange.getIn().getHeader(SIGNATURE_KEY_USERID, (Object)this.getSignatureKeyUserid(), String.class);
    }

    protected List<String> findSignatureKeyUserids(Exchange exchange) {
        return (List)exchange.getIn().getHeader(SIGNATURE_KEY_USERIDS, this.getSignatureKeyUserids(), List.class);
    }

    protected String findSignatureKeyPassword(Exchange exchange) {
        String sigPassword = (String)exchange.getIn().getHeader(SIGNATURE_KEY_PASSWORD, (Object)this.getSignaturePassword(), String.class);
        if (sigPassword != null) {
            return sigPassword;
        }
        if (this.passphraseAccessor != null) {
            return this.passphraseAccessor.getPassphrase(this.findSignatureKeyUserid(exchange));
        }
        return null;
    }

    protected int findCompressionAlgorithm(Exchange exchange) {
        return (Integer)exchange.getIn().getHeader(COMPRESSION_ALGORITHM, (Object)this.getCompressionAlgorithm(), Integer.class);
    }

    protected int findAlgorithm(Exchange exchange) {
        return (Integer)exchange.getIn().getHeader(ENCRYPTION_ALGORITHM, (Object)this.getAlgorithm(), Integer.class);
    }

    protected int findHashAlgorithm(Exchange exchange) {
        return (Integer)exchange.getIn().getHeader(SIGNATURE_HASH_ALGORITHM, (Object)this.getHashAlgorithm(), Integer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream outputStream) throws Exception {
        List<String> userids = this.determineEncryptionUserIds(exchange);
        List<PGPPublicKey> keys = PGPDataFormatUtil.findPublicKeys(exchange.getContext(), this.findKeyFileName(exchange), this.findEncryptionKeyRing(exchange), userids, true);
        if (keys.isEmpty()) {
            throw new IllegalArgumentException("Cannot PGP encrypt message. No public encryption key found for the User Ids " + userids + " in the public keyring. Either specify other User IDs or add correct public keys to the keyring.");
        }
        exchange.getOut().setHeader(NUMBER_OF_ENCRYPTION_KEYS, (Object)keys.size());
        InputStream input = (InputStream)ExchangeHelper.convertToMandatoryType((Exchange)exchange, InputStream.class, (Object)graph);
        if (this.armored) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(this.findAlgorithm(exchange)).setWithIntegrityPacket(this.integrity).setSecureRandom(new SecureRandom()).setProvider(this.getProvider()));
        for (PGPPublicKey key : keys) {
            encGen.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(key));
        }
        OutputStream encOut = encGen.open(outputStream, new byte[16384]);
        PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(this.findCompressionAlgorithm(exchange));
        BufferedOutputStream comOut = new BufferedOutputStream(comData.open(encOut));
        List<PGPSignatureGenerator> sigGens = this.createSignatureGenerator(exchange, comOut);
        PGPLiteralDataGenerator litData = new PGPLiteralDataGenerator();
        String fileName = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        if (ObjectHelper.isEmpty((Object)fileName)) {
            fileName = "_CONSOLE";
        }
        OutputStream litOut = litData.open((OutputStream)comOut, 'b', fileName, new Date(), new byte[16384]);
        try {
            int bytesRead;
            byte[] buffer = new byte[16384];
            while ((bytesRead = input.read(buffer)) != -1) {
                litOut.write(buffer, 0, bytesRead);
                if (sigGens != null && !sigGens.isEmpty()) {
                    for (PGPSignatureGenerator sigGen : sigGens) {
                        sigGen.update(buffer, 0, bytesRead);
                    }
                }
                litOut.flush();
            }
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable)litOut);
            if (sigGens != null && !sigGens.isEmpty()) {
                for (int i = sigGens.size() - 1; i > -1; --i) {
                    PGPSignatureGenerator sigGen = sigGens.get(i);
                    sigGen.generate().encode((OutputStream)comOut);
                }
            }
            IOHelper.close((Closeable[])new Closeable[]{comOut, encOut, outputStream, input});
            throw throwable;
        }
        IOHelper.close((Closeable)litOut);
        if (sigGens != null && !sigGens.isEmpty()) {
            for (int i = sigGens.size() - 1; i > -1; --i) {
                PGPSignatureGenerator sigGen = sigGens.get(i);
                sigGen.generate().encode((OutputStream)comOut);
            }
        }
        IOHelper.close((Closeable[])new Closeable[]{comOut, encOut, outputStream, input});
    }

    protected List<String> determineEncryptionUserIds(Exchange exchange) {
        List<String> result;
        String userid = this.findKeyUserid(exchange);
        List<String> userids = this.findKeyUserids(exchange);
        if (userid != null) {
            if (userids == null || userids.isEmpty()) {
                result = Collections.singletonList(userid);
            } else {
                result = new ArrayList<String>(userids.size() + 1);
                result.add(userid);
                result.addAll(userids);
            }
        } else {
            if (userids == null || userids.isEmpty()) {
                throw new IllegalStateException("Cannot PGP encrypt message. No User ID of the public key specified.");
            }
            result = userids;
        }
        return result;
    }

    protected List<String> determineSignaturenUserIds(Exchange exchange) {
        List<String> result;
        String userid = this.findSignatureKeyUserid(exchange);
        List<String> userids = this.findSignatureKeyUserids(exchange);
        if (userid != null) {
            if (userids == null || userids.isEmpty()) {
                result = Collections.singletonList(userid);
            } else {
                result = new ArrayList<String>(userids.size() + 1);
                result.add(userid);
                result.addAll(userids);
            }
        } else {
            result = userids;
        }
        return result;
    }

    protected List<PGPSignatureGenerator> createSignatureGenerator(Exchange exchange, OutputStream out) throws IOException, PGPException, NoSuchProviderException, NoSuchAlgorithmException {
        String sigKeyFileName = this.findSignatureKeyFileName(exchange);
        List<String> sigKeyUserids = this.determineSignaturenUserIds(exchange);
        String sigKeyPassword = this.findSignatureKeyPassword(exchange);
        byte[] sigKeyRing = this.findSignatureKeyRing(exchange);
        if (sigKeyFileName == null && sigKeyRing == null || sigKeyUserids == null || sigKeyUserids.isEmpty() || sigKeyPassword == null && this.passphraseAccessor == null) {
            return null;
        }
        List<PGPDataFormatUtil.PGPSecretKeyAndPrivateKeyAndUserId> sigSecretKeysWithPrivateKeyAndUserId = this.determineSecretKeysWithPrivateKeyAndUserId(exchange, sigKeyFileName, sigKeyUserids, sigKeyPassword, sigKeyRing);
        exchange.getOut().setHeader(NUMBER_OF_SIGNING_KEYS, (Object)sigSecretKeysWithPrivateKeyAndUserId.size());
        ArrayList<PGPSignatureGenerator> sigGens = new ArrayList<PGPSignatureGenerator>();
        for (PGPDataFormatUtil.PGPSecretKeyAndPrivateKeyAndUserId sigSecretKeyWithPrivateKeyAndUserId : sigSecretKeysWithPrivateKeyAndUserId) {
            PGPPrivateKey sigPrivateKey = sigSecretKeyWithPrivateKeyAndUserId.getPrivateKey();
            PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator();
            spGen.setSignerUserID(false, sigSecretKeyWithPrivateKeyAndUserId.getUserId());
            int algorithm = sigSecretKeyWithPrivateKeyAndUserId.getSecretKey().getPublicKey().getAlgorithm();
            PGPSignatureGenerator sigGen = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(algorithm, this.findHashAlgorithm(exchange)).setProvider(this.getProvider()));
            sigGen.init(0, sigPrivateKey);
            sigGen.setHashedSubpackets(spGen.generate());
            sigGen.generateOnePassVersion(false).encode(out);
            sigGens.add(sigGen);
        }
        return sigGens;
    }

    public List<PGPDataFormatUtil.PGPSecretKeyAndPrivateKeyAndUserId> determineSecretKeysWithPrivateKeyAndUserId(Exchange exchange, String sigKeyFileName, List<String> sigKeyUserids, String sigKeyPassword, byte[] sigKeyRing) throws IOException, PGPException, NoSuchProviderException {
        Map<String, String> sigKeyUserId2Password = this.determineSignatureKeyUserId2Password(sigKeyUserids, sigKeyPassword);
        List<PGPDataFormatUtil.PGPSecretKeyAndPrivateKeyAndUserId> sigSecretKeysWithPrivateKeyAndUserId = PGPDataFormatUtil.findSecretKeysWithPrivateKeyAndUserId(exchange.getContext(), sigKeyFileName, sigKeyRing, sigKeyUserId2Password, this.getProvider());
        if (sigSecretKeysWithPrivateKeyAndUserId.isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot PGP sign message. No secret key found for User IDs %s. Either add keys with this User IDs to the secret keyring or change the configured User IDs.", sigKeyUserids));
        }
        return sigSecretKeysWithPrivateKeyAndUserId;
    }

    public Map<String, String> determineSignatureKeyUserId2Password(List<String> sigKeyUserids, String sigKeyPassword) {
        LinkedHashMap<String, String> sigKeyUserId2Password = new LinkedHashMap<String, String>(sigKeyUserids.size());
        for (String sigKeyUserid : sigKeyUserids) {
            if (sigKeyPassword == null) {
                sigKeyPassword = this.passphraseAccessor.getPassphrase(sigKeyUserid);
            }
            if (sigKeyPassword == null) {
                throw new IllegalArgumentException(String.format("No passphrase specified for signature key user ID %s. Either specify a passphrase or remove this user ID from the configuration.", sigKeyUserid));
            }
            sigKeyUserId2Password.put(sigKeyUserid, sigKeyPassword);
        }
        return sigKeyUserId2Password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream encryptedStream) throws Exception {
        ByteArrayOutputStream os;
        ByteArrayOutputStream bos;
        CachedOutputStream cos;
        PGPOnePassSignature signature;
        if (encryptedStream == null) {
            return null;
        }
        InputStream in = PGPUtil.getDecoderStream((InputStream)encryptedStream);
        PGPObjectFactory pgpFactory = new PGPObjectFactory(in);
        Object o = pgpFactory.nextObject();
        PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpFactory.nextObject();
        PGPPublicKeyEncryptedData pbe = null;
        PGPPrivateKey key = null;
        for (int i = 0; i < enc.size() && key == null; ++i) {
            pbe = (PGPPublicKeyEncryptedData)enc.get(i);
            key = PGPDataFormatUtil.findPrivateKeyWithKeyId(exchange.getContext(), this.findKeyFileName(exchange), this.findEncryptionKeyRing(exchange), pbe.getKeyID(), this.findKeyPassword(exchange), this.getPassphraseAccessor(), this.getProvider());
            if (key != null) break;
        }
        if (key == null) {
            throw new PGPException("Provided input is encrypted with unknown pair of keys.");
        }
        InputStream encData = pbe.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider(this.getProvider()).build(key));
        pgpFactory = new PGPObjectFactory(encData);
        PGPCompressedData comData = (PGPCompressedData)pgpFactory.nextObject();
        Object object = (pgpFactory = new PGPObjectFactory(comData.getDataStream())).nextObject();
        if (object instanceof PGPOnePassSignatureList) {
            signature = this.getSignature(exchange, (PGPOnePassSignatureList)object);
            object = pgpFactory.nextObject();
        } else {
            signature = null;
        }
        PGPLiteralData ld = (PGPLiteralData)object;
        InputStream litData = ld.getInputStream();
        if (exchange.getContext().getStreamCachingStrategy().isEnabled()) {
            cos = new CachedOutputStream(exchange);
            bos = null;
            os = cos;
        } else {
            cos = null;
            os = bos = new ByteArrayOutputStream();
        }
        try {
            int bytesRead;
            byte[] buffer = new byte[16384];
            while ((bytesRead = litData.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
                if (signature != null) {
                    signature.update(buffer, 0, bytesRead);
                }
                os.flush();
            }
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{os, litData, encData, in});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{os, litData, encData, in});
        if (signature != null) {
            PGPSignatureList sigList = (PGPSignatureList)pgpFactory.nextObject();
            if (!signature.verify(this.getSignatureWithKeyId(signature.getKeyID(), sigList))) {
                throw new SignatureException("Cannot verify PGP signature");
            }
        }
        if (cos != null) {
            return cos.newStreamCache();
        }
        return bos.toByteArray();
    }

    protected PGPSignature getSignatureWithKeyId(long keyID, PGPSignatureList sigList) {
        for (int i = 0; i < sigList.size(); ++i) {
            PGPSignature signature = sigList.get(i);
            if (keyID != signature.getKeyID()) continue;
            return signature;
        }
        throw new IllegalStateException("PGP signature is inconsistent");
    }

    protected PGPOnePassSignature getSignature(Exchange exchange, PGPOnePassSignatureList signatureList) throws IOException, PGPException, NoSuchProviderException {
        List<String> allowedUserIds = this.determineSignaturenUserIds(exchange);
        for (int i = 0; i < signatureList.size(); ++i) {
            PGPOnePassSignature signature = signatureList.get(i);
            PGPPublicKey sigPublicKey = PGPDataFormatUtil.findPublicKeyWithKeyId(exchange.getContext(), this.findSignatureKeyFileName(exchange), this.findSignatureKeyRing(exchange), signature.getKeyID(), false);
            if (sigPublicKey == null || !this.isAllowedVerifyingKey(allowedUserIds, sigPublicKey)) continue;
            signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider(this.getProvider()), sigPublicKey);
            return signature;
        }
        if (signatureList.isEmpty()) {
            return null;
        }
        throw new IllegalArgumentException("No public key found fitting to the signature key Id; cannot verify the signature");
    }

    public boolean isAllowedVerifyingKey(List<String> allowedUserIds, PGPPublicKey verifyingPublicKey) {
        if (allowedUserIds == null || allowedUserIds.isEmpty()) {
            return true;
        }
        String keyUserId = null;
        Iterator iterator = verifyingPublicKey.getUserIDs();
        while (iterator.hasNext()) {
            keyUserId = (String)iterator.next();
            for (String userid : allowedUserIds) {
                if (keyUserId == null || !keyUserId.contains(userid)) continue;
                LOG.debug("Public key with  user ID {} fulfills the User ID restriction {}. Therefore this key will be used for the signature verification. ", (Object)keyUserId, allowedUserIds);
                return true;
            }
        }
        LOG.warn("Public key with User ID {} does not fulfill the User ID restriction {}. Therefore this key will not be used for the signature verification.", (Object)keyUserId, allowedUserIds);
        return false;
    }

    public void setArmored(boolean armored) {
        this.armored = armored;
    }

    public boolean getArmored() {
        return this.armored;
    }

    public void setIntegrity(boolean integrity) {
        this.integrity = integrity;
    }

    public boolean getIntegrity() {
        return this.integrity;
    }

    public void setKeyUserid(String keyUserid) {
        this.keyUserid = keyUserid;
    }

    public String getKeyUserid() {
        return this.keyUserid;
    }

    public List<String> getKeyUserids() {
        return this.keyUserids;
    }

    public void setKeyUserids(List<String> keyUserids) {
        this.keyUserids = keyUserids;
    }

    public void setKeyFileName(String keyFileName) {
        this.keyFileName = keyFileName;
    }

    public String getKeyFileName() {
        return this.keyFileName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSignatureKeyUserid(String signatureKeyUserid) {
        this.signatureKeyUserid = signatureKeyUserid;
    }

    public String getSignatureKeyUserid() {
        return this.signatureKeyUserid;
    }

    public List<String> getSignatureKeyUserids() {
        return this.signatureKeyUserids;
    }

    public void setSignatureKeyUserids(List<String> signatureKeyUserids) {
        this.signatureKeyUserids = signatureKeyUserids;
    }

    public void setSignatureKeyFileName(String signatureKeyFileName) {
        this.signatureKeyFileName = signatureKeyFileName;
    }

    public String getSignatureKeyFileName() {
        return this.signatureKeyFileName;
    }

    public void setSignaturePassword(String signaturePassword) {
        this.signaturePassword = signaturePassword;
    }

    public String getSignaturePassword() {
        return this.signaturePassword;
    }

    public byte[] getEncryptionKeyRing() {
        return this.encryptionKeyRing;
    }

    public void setEncryptionKeyRing(byte[] encryptionKeyRing) {
        this.encryptionKeyRing = encryptionKeyRing;
    }

    public byte[] getSignatureKeyRing() {
        return this.signatureKeyRing;
    }

    public void setSignatureKeyRing(byte[] signatureKeyRing) {
        this.signatureKeyRing = signatureKeyRing;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public int getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(int compressionAlgorithm) {
        this.compressionAlgorithm = compressionAlgorithm;
    }

    public int getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(int hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(int algorithm) {
        this.algorithm = algorithm;
    }

    public PGPPassphraseAccessor getPassphraseAccessor() {
        return this.passphraseAccessor;
    }

    public void setPassphraseAccessor(PGPPassphraseAccessor passphraseAccessor) {
        this.passphraseAccessor = passphraseAccessor;
    }

    protected void doStart() throws Exception {
        if (Security.getProvider(BC) == null && BC.equals(this.getProvider())) {
            LOG.debug("Adding BouncyCastleProvider as security provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            LOG.debug("Using custom provider {} which is expected to be enlisted manually.", (Object)this.getProvider());
        }
    }

    protected void doStop() throws Exception {
    }
}

