/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.blueprint;

import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.test.blueprint.CamelBlueprintHelper;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.apache.camel.util.KeyValueHolder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public abstract class CamelBlueprintTestSupport
extends CamelTestSupport {
    public static final String SPROP_CAMEL_CONTEXT_CREATION_TIMEOUT = "org.apache.camel.test.blueprint.camelContextCreationTimeout";
    private static ThreadLocal<BundleContext> threadLocalBundleContext = new ThreadLocal();
    private volatile BundleContext bundleContext;
    private final Set<ServiceRegistration<?>> services = new LinkedHashSet();

    protected boolean includeTestBundle() {
        return true;
    }

    protected BundleContext createBundleContext() throws Exception {
        String pid;
        final String symbolicName = ((Object)((Object)this)).getClass().getSimpleName();
        final BundleContext answer = CamelBlueprintHelper.createBundleContext(symbolicName, this.getBlueprintDescriptor(), this.includeTestBundle(), this.getBundleFilter(), this.getBundleVersion(), this.getBundleDirectives());
        Properties extra = this.useOverridePropertiesWithPropertiesComponent();
        if (extra != null) {
            answer.registerService(PropertiesComponent.OVERRIDE_PROPERTIES, (Object)extra, null);
        }
        LinkedHashMap<String, KeyValueHolder<Object, Dictionary>> map = new LinkedHashMap<String, KeyValueHolder<Object, Dictionary>>();
        this.addServicesOnStartup(map);
        for (Map.Entry entry : map.entrySet()) {
            String clazz = (String)entry.getKey();
            Object service = ((KeyValueHolder)entry.getValue()).getKey();
            Dictionary dict = (Dictionary)((KeyValueHolder)entry.getValue()).getValue();
            this.log.debug("Registering service {} -> {}", (Object)clazz, service);
            ServiceRegistration reg = answer.registerService(clazz, service, dict);
            if (reg == null) continue;
            this.services.add(reg);
        }
        Properties props = new Properties();
        String[] file = this.loadConfigAdminConfigurationFile();
        if (file != null && file.length != 2) {
            throw new IllegalArgumentException("The returned String[] from loadConfigAdminConfigurationFile must be of length 2, was " + file.length);
        }
        if (file != null) {
            CamelBlueprintHelper.setPersistentFileForConfigAdmin(answer, file[1], file[0], props);
        }
        if ((pid = this.useOverridePropertiesWithConfigAdmin(props)) != null) {
            final CountDownLatch latch = new CountDownLatch(2);
            answer.registerService(ConfigurationListener.class, (Object)new ConfigurationListener(){

                public void configurationEvent(ConfigurationEvent event) {
                    if (event.getType() == 3) {
                        latch.countDown();
                    }
                    answer.registerService(BlueprintListener.class, (Object)new BlueprintListener(){

                        public void blueprintEvent(BlueprintEvent event) {
                            if (event.getType() == 2 && event.getBundle().getSymbolicName().equals(symbolicName)) {
                                latch.countDown();
                            }
                        }
                    }, null);
                }
            }, null);
            ConfigurationAdmin configAdmin = CamelBlueprintHelper.getOsgiService(answer, ConfigurationAdmin.class);
            Configuration config = configAdmin.getConfiguration(pid, null);
            if (config == null) {
                throw new IllegalArgumentException("Cannot find configuration with pid " + pid + " in OSGi ConfigurationAdmin service.");
            }
            this.log.info("Updating ConfigAdmin {} by overriding properties {}", (Object)config, (Object)props);
            config.update((Dictionary)props);
            latch.await(30000L, TimeUnit.MILLISECONDS);
        }
        return answer;
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("skipStartingCamelContext", "true");
        System.setProperty("registerBlueprintCamelContextEager", "true");
        String symbolicName = ((Object)((Object)this)).getClass().getSimpleName();
        if (this.isCreateCamelContextPerClass()) {
            boolean first;
            boolean bl = first = threadLocalBundleContext.get() == null;
            if (first) {
                threadLocalBundleContext.set(this.createBundleContext());
            }
            this.bundleContext = threadLocalBundleContext.get();
        } else {
            this.bundleContext = this.createBundleContext();
        }
        super.setUp();
        this.log.debug("Staring CamelContext: {}", (Object)this.context.getName());
        this.context.start();
        this.log.debug("Waiting for BlueprintContainer to be published with symbolicName: {}", (Object)symbolicName);
        this.getOsgiService(BlueprintContainer.class, "(osgi.blueprint.container.symbolicname=" + symbolicName + ")");
    }

    protected void addServicesOnStartup(Map<String, KeyValueHolder<Object, Dictionary>> services) {
    }

    protected KeyValueHolder<Object, Dictionary> asService(Object service, Dictionary dict) {
        return new KeyValueHolder(service, (Object)dict);
    }

    protected KeyValueHolder<Object, Dictionary> asService(Object service, String key, String value) {
        Properties prop = new Properties();
        if (key != null && value != null) {
            prop.put(key, value);
        }
        return new KeyValueHolder(service, (Object)prop);
    }

    protected String useOverridePropertiesWithConfigAdmin(Dictionary props) throws Exception {
        return null;
    }

    protected String[] loadConfigAdminConfigurationFile() {
        return null;
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("skipStartingCamelContext");
        System.clearProperty("registerBlueprintCamelContextEager");
        super.tearDown();
        if (this.isCreateCamelContextPerClass()) {
            return;
        }
        if (this.bundleContext != null) {
            for (ServiceRegistration<?> reg : this.services) {
                this.bundleContext.ungetService(reg.getReference());
            }
        }
        CamelBlueprintHelper.disposeBundleContext(this.bundleContext);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (threadLocalBundleContext.get() != null) {
            CamelBlueprintHelper.disposeBundleContext(threadLocalBundleContext.get());
            threadLocalBundleContext.remove();
        }
        CamelTestSupport.tearDownAfterClass();
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected String getBlueprintDescriptor() {
        return null;
    }

    protected String getBundleFilter() {
        return "(Bundle-SymbolicName=*)";
    }

    protected String getBundleVersion() {
        return "1.0.0";
    }

    protected String getBundleDirectives() {
        return null;
    }

    protected Long getCamelContextCreationTimeout() {
        String tm = System.getProperty(SPROP_CAMEL_CONTEXT_CREATION_TIMEOUT);
        if (tm == null) {
            return null;
        }
        try {
            Long val = Long.valueOf(tm);
            if (val < 0L) {
                throw new IllegalArgumentException("Value of org.apache.camel.test.blueprint.camelContextCreationTimeout cannot be negative.");
            }
            return val;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Value of org.apache.camel.test.blueprint.camelContextCreationTimeout has wrong format.", e);
        }
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext answer = null;
        Long timeout = this.getCamelContextCreationTimeout();
        if (timeout == null) {
            answer = CamelBlueprintHelper.getOsgiService(this.bundleContext, CamelContext.class);
        } else if (timeout >= 0L) {
            answer = CamelBlueprintHelper.getOsgiService(this.bundleContext, CamelContext.class, timeout);
        } else {
            throw new IllegalArgumentException("getCamelContextCreationTimeout cannot return a negative value.");
        }
        this.context = (ModelCamelContext)answer;
        return answer;
    }

    protected <T> T getOsgiService(Class<T> type) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type);
    }

    protected <T> T getOsgiService(Class<T> type, long timeout) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, timeout);
    }

    protected <T> T getOsgiService(Class<T> type, String filter) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, filter);
    }

    protected <T> T getOsgiService(Class<T> type, String filter, long timeout) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, filter, timeout);
    }
}

