/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.camel.Service;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.internal.dto.LoginError;
import org.apache.camel.component.salesforce.internal.dto.LoginToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.UrlEncoded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceSession
implements Service {
    private static final String OAUTH2_REVOKE_PATH = "/services/oauth2/revoke?token=";
    private static final String OAUTH2_TOKEN_PATH = "/services/oauth2/token";
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceSession.class);
    private static final String FORM_CONTENT_TYPE = "application/x-www-form-urlencoded;charset=utf-8";
    private final HttpClient httpClient;
    private final SalesforceLoginConfig config;
    private final ObjectMapper objectMapper;
    private final Set<SalesforceSessionListener> listeners;
    private String accessToken;
    private String instanceUrl;

    public SalesforceSession(HttpClient httpClient, SalesforceLoginConfig config) {
        this.assertNotNull("Null httpClient", httpClient);
        this.assertNotNull("Null SalesforceLoginConfig", config);
        this.assertNotNull("Null loginUrl", config.getLoginUrl());
        this.assertNotNull("Null clientId", config.getClientId());
        this.assertNotNull("Null clientSecret", config.getClientSecret());
        this.assertNotNull("Null userName", config.getUserName());
        this.assertNotNull("Null password", config.getPassword());
        this.httpClient = httpClient;
        this.config = config;
        String loginUrl = config.getLoginUrl();
        config.setLoginUrl(loginUrl.endsWith("/") ? loginUrl.substring(0, loginUrl.length() - 1) : loginUrl);
        this.objectMapper = new ObjectMapper();
        this.listeners = new CopyOnWriteArraySet<SalesforceSessionListener>();
    }

    private void assertNotNull(String s, Object o) {
        if (o == null) {
            throw new IllegalArgumentException(s);
        }
    }

    public synchronized String login(String oldToken) throws SalesforceException {
        block20: {
            if (this.accessToken == null || this.accessToken.equals(oldToken)) {
                this.accessToken = oldToken;
                if (this.accessToken != null) {
                    try {
                        this.logout();
                    }
                    catch (SalesforceException e) {
                        LOG.warn("Error revoking old access token: " + e.getMessage(), (Throwable)((Object)e));
                    }
                    this.accessToken = null;
                }
                StatusExceptionExchange loginPost = new StatusExceptionExchange(true);
                String url = this.config.getLoginUrl() + OAUTH2_TOKEN_PATH;
                loginPost.setURL(url);
                loginPost.setMethod("POST");
                loginPost.setRequestContentType(FORM_CONTENT_TYPE);
                UrlEncoded nvps = new UrlEncoded();
                nvps.put((Object)"grant_type", (Object)"password");
                nvps.put((Object)"client_id", (Object)this.config.getClientId());
                nvps.put((Object)"client_secret", (Object)this.config.getClientSecret());
                nvps.put((Object)"username", (Object)this.config.getUserName());
                nvps.put((Object)"password", (Object)this.config.getPassword());
                nvps.put((Object)"format", (Object)"json");
                try {
                    LOG.info("Login user {} at Salesforce url: {}", (Object)this.config.getUserName(), (Object)url);
                    loginPost.setRequestContent((Buffer)new ByteArrayBuffer(nvps.encode("UTF-8", true).getBytes("UTF-8")));
                    this.httpClient.send((HttpExchange)loginPost);
                    int exchangeState = loginPost.waitForDone();
                    switch (exchangeState) {
                        case 7: {
                            byte[] responseContent = loginPost.getResponseContentBytes();
                            int responseStatus = loginPost.getResponseStatus();
                            switch (responseStatus) {
                                case 200: {
                                    LoginToken token = (LoginToken)this.objectMapper.readValue(responseContent, LoginToken.class);
                                    LOG.info("Login successful");
                                    this.accessToken = token.getAccessToken();
                                    this.instanceUrl = token.getInstanceUrl();
                                    for (SalesforceSessionListener listener : this.listeners) {
                                        try {
                                            listener.onLogin(this.accessToken, this.instanceUrl);
                                        }
                                        catch (Throwable t) {
                                            LOG.warn("Unexpected error from listener {}: {}", (Object)listener, (Object)t.getMessage());
                                        }
                                    }
                                    break block20;
                                }
                                case 400: {
                                    LoginError error = (LoginError)this.objectMapper.readValue(responseContent, LoginError.class);
                                    String msg = String.format("Login error code:[%s] description:[%s]", error.getError(), error.getErrorDescription());
                                    ArrayList<RestError> errors = new ArrayList<RestError>();
                                    errors.add(new RestError(msg, error.getErrorDescription()));
                                    throw new SalesforceException(errors, 400);
                                }
                                default: {
                                    throw new SalesforceException(String.format("Login error status:[%s] reason:[%s]", responseStatus, loginPost.getReason()), responseStatus);
                                }
                            }
                        }
                        case 9: {
                            Throwable ex = loginPost.getException();
                            throw new SalesforceException(String.format("Unexpected login exception: %s", ex.getMessage()), ex);
                        }
                        case 11: {
                            throw new SalesforceException("Login request CANCELLED!", null);
                        }
                        case 8: {
                            throw new SalesforceException("Login request TIMEOUT!", null);
                        }
                        default: {
                            throw new SalesforceException("Unknow status: " + exchangeState, null);
                        }
                    }
                }
                catch (IOException e) {
                    String msg = "Login error: unexpected exception " + e.getMessage();
                    throw new SalesforceException(msg, e);
                }
                catch (InterruptedException e) {
                    String msg = "Login error: unexpected exception " + e.getMessage();
                    throw new SalesforceException(msg, e);
                }
            }
        }
        return this.accessToken;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logout() throws SalesforceException {
        if (this.accessToken == null) {
            return;
        }
        StatusExceptionExchange logoutGet = new StatusExceptionExchange(true);
        logoutGet.setURL(this.config.getLoginUrl() + OAUTH2_REVOKE_PATH + this.accessToken);
        logoutGet.setMethod("GET");
        try {
            this.httpClient.send((HttpExchange)logoutGet);
            int done = logoutGet.waitForDone();
            switch (done) {
                case 7: {
                    int statusCode = logoutGet.getResponseStatus();
                    String reason = logoutGet.getReason();
                    if (statusCode != 200) throw new SalesforceException(String.format("Logout error, code: [%s] reason: [%s]", statusCode, reason), statusCode);
                    LOG.info("Logout successful");
                    return;
                }
                case 9: {
                    Throwable ex = logoutGet.getException();
                    throw new SalesforceException("Unexpected logout exception: " + ex.getMessage(), ex);
                }
                case 11: {
                    throw new SalesforceException("Logout request CANCELLED!", null);
                }
                case 8: {
                    throw new SalesforceException("Logout request TIMEOUT!", null);
                }
                default: {
                    throw new SalesforceException("Unknow status: " + done, null);
                }
            }
        }
        catch (SalesforceException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Logout error: " + e.getMessage();
            throw new SalesforceException(msg, e);
        }
        finally {
            this.accessToken = null;
            this.instanceUrl = null;
            for (SalesforceSessionListener listener : this.listeners) {
                try {
                    listener.onLogout();
                }
                catch (Throwable t) {
                    LOG.warn("Unexpected error from listener {}: {}", (Object)listener, (Object)t.getMessage());
                }
            }
        }
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public boolean addListener(SalesforceSessionListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(SalesforceSessionListener listener) {
        return this.listeners.remove(listener);
    }

    public void start() throws Exception {
        this.login(this.accessToken);
    }

    public void stop() throws Exception {
        this.logout();
    }

    public static interface SalesforceSessionListener {
        public void onLogin(String var1, String var2);

        public void onLogout();
    }

    private static class StatusExceptionExchange
    extends ContentExchange {
        private String reason;
        private Throwable exception;

        public StatusExceptionExchange(boolean cacheFields) {
            super(cacheFields);
        }

        protected synchronized void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
            this.reason = reason.toString("ISO-8859-1");
            super.onResponseStatus(version, status, reason);
        }

        protected void onConnectionFailed(Throwable x) {
            this.exception = x;
            super.onConnectionFailed(x);
        }

        protected void onException(Throwable x) {
            this.exception = x;
            super.onException(x);
        }

        public String getReason() {
            return this.reason;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

