/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.component.twitter.Twitter4JFactory;
import org.apache.camel.component.twitter.TwitterComponent;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.consumer.Twitter4JConsumer;
import org.apache.camel.component.twitter.consumer.TwitterConsumerEvent;
import org.apache.camel.component.twitter.data.EndpointType;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(scheme="twitter", consumerClass=Twitter4JConsumer.class)
public class TwitterEndpointEvent
extends DirectEndpoint
implements TwitterEndpoint {
    @UriParam
    private TwitterConfiguration properties;

    public TwitterEndpointEvent(String uri, TwitterComponent component, TwitterConfiguration properties) {
        super(uri, (Component)component);
        this.properties = properties;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        Twitter4JConsumer twitter4jConsumer = Twitter4JFactory.getConsumer(this, this.getEndpointUri());
        return new TwitterConsumerEvent(this, processor, twitter4jConsumer);
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Producer not supported");
    }

    @Override
    public TwitterConfiguration getProperties() {
        return this.properties;
    }

    public void setProperties(TwitterConfiguration properties) {
        this.properties = properties;
    }

    @Override
    public EndpointType getEndpointType() {
        return EndpointType.EVENT;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.properties.getTwitterStream() != null) {
            this.properties.getTwitterStream().shutdown();
        }
    }

    public void shutdown() throws Exception {
        super.shutdown();
        this.properties.getTwitter().shutdown();
    }
}

