/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.producer.Twitter4JProducer;
import twitter4j.Status;
import twitter4j.StatusUpdate;

public class UserProducer
extends Twitter4JProducer {
    public UserProducer(TwitterEndpoint te) {
        super(te);
    }

    public void process(Exchange exchange) throws Exception {
        Status response;
        Object in = exchange.getIn().getBody();
        if (in instanceof StatusUpdate) {
            response = this.updateStatus((StatusUpdate)in);
        } else {
            String s = (String)exchange.getIn().getMandatoryBody(String.class);
            response = this.updateStatus(s);
        }
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody((Object)response);
        }
    }

    private Status updateStatus(StatusUpdate status) throws Exception {
        Status reponse = this.te.getProperties().getTwitter().updateStatus(status);
        this.log.debug("Updated status: {}", (Object)status);
        this.log.debug("Status id: {}", (Object)reponse.getId());
        return reponse;
    }

    private Status updateStatus(String status) throws Exception {
        if (status.length() > 160) {
            this.log.warn("Message is longer than 160 characters. Message will be truncated!");
            status = status.substring(0, 160);
        }
        Status response = this.te.getProperties().getTwitter().updateStatus(status);
        this.log.debug("Updated status: {}", (Object)status);
        this.log.debug("Status id: {}", (Object)response.getId());
        return response;
    }
}

