/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.sf.flatpack.Parser;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.flatpack.FixedLengthEndpoint;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;

public class DelimitedEndpoint
extends FixedLengthEndpoint {
    private char delimiter = (char)44;
    private char textQualifier = (char)34;
    private boolean ignoreFirstRecord = true;

    public DelimitedEndpoint() {
    }

    public DelimitedEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component, resourceUri);
    }

    @Override
    public Parser createParser(Exchange exchange) throws InvalidPayloadException, IOException {
        Reader bodyReader = (Reader)exchange.getIn().getMandatoryBody(Reader.class);
        if (ObjectHelper.isEmpty((Object)this.getDefinition())) {
            return this.getParserFactory().newDelimitedParser(bodyReader, this.delimiter, this.textQualifier);
        }
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.getCamelContext().getClassResolver(), (String)this.definition);
        InputStreamReader reader = new InputStreamReader(is, IOHelper.getCharsetName((Exchange)exchange));
        Parser parser = this.getParserFactory().newDelimitedParser((Reader)reader, bodyReader, this.delimiter, this.textQualifier, this.ignoreFirstRecord);
        if (this.isAllowShortLines()) {
            parser.setHandlingShortLines(true);
            parser.setIgnoreParseWarnings(true);
        }
        if (this.isIgnoreExtraColumns()) {
            parser.setIgnoreExtraColumns(true);
            parser.setIgnoreParseWarnings(true);
        }
        return parser;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isIgnoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    public void setIgnoreFirstRecord(boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    public char getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(char textQualifier) {
        this.textQualifier = textQualifier;
    }
}

