/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.sjms.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.IllegalHeaderException;
import org.apache.camel.component.sjms.jms.JmsMessageHeaderType;
import org.apache.camel.component.sjms.jms.JmsMessageHelper;
import org.apache.camel.component.sjms.jms.JmsMessageType;
import org.apache.camel.component.sjms.jms.KeyFormatStrategy;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SjmsExchangeMessageHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SjmsExchangeMessageHelper.class);

    private SjmsExchangeMessageHelper() {
    }

    public static Exchange createExchange(Message message, Endpoint endpoint) {
        Exchange exchange = endpoint.createExchange();
        return SjmsExchangeMessageHelper.populateExchange(message, exchange, false);
    }

    public static Exchange populateExchange(Message message, Exchange exchange, boolean out) {
        try {
            SjmsExchangeMessageHelper.setJmsMessageHeaders(message, exchange, out);
            if (message != null) {
                DefaultMessage bodyMessage = null;
                bodyMessage = out ? (DefaultMessage)exchange.getOut() : (DefaultMessage)exchange.getIn();
                switch (JmsMessageHelper.discoverJmsMessageType(message)) {
                    case Bytes: {
                        BytesMessage bytesMessage = (BytesMessage)message;
                        if (bytesMessage.getBodyLength() > Integer.MAX_VALUE) {
                            LOGGER.warn("Length of BytesMessage is too long: {}", (Object)bytesMessage.getBodyLength());
                            return null;
                        }
                        byte[] result = new byte[(int)bytesMessage.getBodyLength()];
                        bytesMessage.readBytes(result);
                        bodyMessage.setHeader("JmsMessageType", (Object)JmsMessageType.Bytes);
                        bodyMessage.setBody((Object)result);
                        break;
                    }
                    case Map: {
                        HashMap<String, Object> body = new HashMap<String, Object>();
                        MapMessage mapMessage = (MapMessage)message;
                        Enumeration names = mapMessage.getMapNames();
                        while (names.hasMoreElements()) {
                            String key = (String)names.nextElement();
                            Object value = mapMessage.getObject(key);
                            body.put(key, value);
                        }
                        bodyMessage.setHeader("JmsMessageType", (Object)JmsMessageType.Map);
                        bodyMessage.setBody(body);
                        break;
                    }
                    case Object: {
                        ObjectMessage objMsg = (ObjectMessage)message;
                        bodyMessage.setHeader("JmsMessageType", (Object)JmsMessageType.Object);
                        bodyMessage.setBody((Object)objMsg.getObject());
                        break;
                    }
                    case Text: {
                        TextMessage textMsg = (TextMessage)message;
                        bodyMessage.setHeader("JmsMessageType", (Object)JmsMessageType.Text);
                        bodyMessage.setBody((Object)textMsg.getText());
                        break;
                    }
                    case Stream: {
                        StreamMessage streamMessage = (StreamMessage)message;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte next = streamMessage.readByte();
                        while (next > -1) {
                            baos.write(next);
                            next = streamMessage.readByte();
                        }
                        baos.flush();
                        bodyMessage.setHeader("JmsMessageType", (Object)JmsMessageType.Bytes);
                        bodyMessage.setBody((Object)baos.toByteArray());
                        break;
                    }
                    default: {
                        bodyMessage.setBody((Object)message);
                    }
                }
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        return exchange;
    }

    public static Object removeJmsProperty(Message jmsMessage, String name) throws JMSException {
        if (!jmsMessage.propertyExists(name)) {
            return null;
        }
        String answer = null;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Enumeration en = jmsMessage.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (name.equals(key)) {
                answer = key;
                continue;
            }
            map.put(key, jmsMessage.getObjectProperty(key));
        }
        jmsMessage.clearProperties();
        for (Map.Entry entry : map.entrySet()) {
            jmsMessage.setObjectProperty((String)entry.getKey(), entry.getValue());
        }
        return answer;
    }

    public static boolean hasProperty(Message jmsMessage, String name) throws JMSException {
        Enumeration en = jmsMessage.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!name.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static void setProperty(Message jmsMessage, String name, Object value) throws JMSException {
        if (value == null) {
            return;
        }
        if (value instanceof Byte) {
            jmsMessage.setByteProperty(name, ((Byte)value).byteValue());
        } else if (value instanceof Boolean) {
            jmsMessage.setBooleanProperty(name, ((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            jmsMessage.setDoubleProperty(name, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            jmsMessage.setFloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Integer) {
            jmsMessage.setIntProperty(name, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            jmsMessage.setLongProperty(name, ((Long)value).longValue());
        } else if (value instanceof Short) {
            jmsMessage.setShortProperty(name, ((Short)value).shortValue());
        } else if (value instanceof String) {
            jmsMessage.setStringProperty(name, (String)value);
        } else {
            jmsMessage.setObjectProperty(name, value);
        }
    }

    public static void setCorrelationId(Message message, String correlationId) {
        block2: {
            try {
                message.setJMSCorrelationID(correlationId);
            }
            catch (JMSException e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Error setting the correlationId: {}", (Object)correlationId);
            }
        }
    }

    public static String normalizeDestinationName(String destination) {
        if (ObjectHelper.isEmpty((Object)destination)) {
            return destination;
        }
        if (destination.startsWith("queue:")) {
            return ObjectHelper.removeStartingCharacters((String)destination.substring("queue:".length()), (char)'/');
        }
        if (destination.startsWith("topic:")) {
            return ObjectHelper.removeStartingCharacters((String)destination.substring("topic:".length()), (char)'/');
        }
        return destination;
    }

    public static void setJMSReplyTo(Message message, Destination replyTo) {
        try {
            message.setJMSReplyTo(replyTo);
        }
        catch (Exception e) {
            LOGGER.debug("Error setting the correlationId: {}", (Object)replyTo.toString());
        }
    }

    public static Destination getJMSReplyTo(Message message) {
        try {
            return message.getJMSReplyTo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getJMSType(Message message) {
        try {
            return message.getJMSType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Boolean getJMSRedelivered(Message message) {
        try {
            return message.getJMSRedelivered();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setJMSDeliveryMode(Exchange exchange, Message message, Object deliveryMode) throws JMSException {
        Integer mode = null;
        if (deliveryMode instanceof String) {
            String s = (String)deliveryMode;
            if ("PERSISTENT".equalsIgnoreCase(s)) {
                mode = 2;
            } else if ("NON_PERSISTENT".equalsIgnoreCase(s)) {
                mode = 1;
            } else {
                Integer value = (Integer)ExchangeHelper.convertToType((Exchange)exchange, Integer.class, (Object)deliveryMode);
                if (value == null) throw new IllegalArgumentException("Unknown delivery mode with value: " + deliveryMode);
                mode = value;
            }
        } else {
            Integer value = (Integer)ExchangeHelper.convertToType((Exchange)exchange, Integer.class, (Object)deliveryMode);
            if (value != null) {
                mode = value;
            }
        }
        if (mode == null) return;
        message.setJMSDeliveryMode(mode.intValue());
        message.setIntProperty("CamelJmsDeliveryMode", mode.intValue());
    }

    public static Message setJmsMessageHeaders(Exchange exchange, Message jmsMessage) throws Exception {
        HashMap headers = new HashMap(exchange.getIn().getHeaders());
        Set keys = headers.keySet();
        for (String headerName : keys) {
            Object headerValue = headers.get(headerName);
            if (headerName.equalsIgnoreCase("JMSCorrelationID")) {
                jmsMessage.setJMSCorrelationID((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, headerValue));
                continue;
            }
            if (headerName.equalsIgnoreCase("JMSReplyTo") && headerValue != null) {
                if (!(headerValue instanceof String)) continue;
                continue;
            }
            if (headerName.equalsIgnoreCase("JMSType")) {
                jmsMessage.setJMSType((String)ExchangeHelper.convertToType((Exchange)exchange, String.class, headerValue));
                continue;
            }
            if (headerName.equalsIgnoreCase("JMSPriority")) {
                jmsMessage.setJMSPriority(((Integer)ExchangeHelper.convertToType((Exchange)exchange, Integer.class, headerValue)).intValue());
                continue;
            }
            if (headerName.equalsIgnoreCase("JMSDeliveryMode")) {
                SjmsExchangeMessageHelper.setJMSDeliveryMode(exchange, jmsMessage, headerValue);
                continue;
            }
            if (headerName.equalsIgnoreCase("JMSExpiration")) {
                jmsMessage.setJMSExpiration(((Long)ExchangeHelper.convertToType((Exchange)exchange, Long.class, headerValue)).longValue());
                continue;
            }
            LOGGER.trace("Ignoring JMS header: {} with value: {}", (Object)headerName, headerValue);
            if (headerName.equalsIgnoreCase("JMSDestination") || headerName.equalsIgnoreCase("JMSMessageID") || headerName.equalsIgnoreCase("JMSTimestamp") || headerName.equalsIgnoreCase("JMSRedelivered")) {
                LOGGER.trace("Ignoring JMS header: {} with value: {}", (Object)headerName, headerValue);
                continue;
            }
            if (headerValue instanceof JmsMessageType) continue;
            String encodedName = new DefaultJmsKeyFormatStrategy().encodeKey(headerName);
            SjmsExchangeMessageHelper.setProperty(jmsMessage, encodedName, headerValue);
        }
        return jmsMessage;
    }

    public static Exchange setJmsMessageHeaders(Message jmsMessage, Exchange exchange, boolean out) throws JMSException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (jmsMessage != null) {
            try {
                headers.put(JmsMessageHeaderType.JMSCorrelationID.toString(), jmsMessage.getJMSCorrelationID());
                headers.put(JmsMessageHeaderType.JMSDeliveryMode.toString(), jmsMessage.getJMSDeliveryMode());
                headers.put(JmsMessageHeaderType.JMSDestination.toString(), jmsMessage.getJMSDestination());
                headers.put(JmsMessageHeaderType.JMSExpiration.toString(), jmsMessage.getJMSExpiration());
                headers.put(JmsMessageHeaderType.JMSMessageID.toString(), jmsMessage.getJMSMessageID());
                headers.put(JmsMessageHeaderType.JMSPriority.toString(), jmsMessage.getJMSPriority());
                headers.put(JmsMessageHeaderType.JMSRedelivered.toString(), jmsMessage.getJMSRedelivered());
                headers.put(JmsMessageHeaderType.JMSTimestamp.toString(), jmsMessage.getJMSTimestamp());
                headers.put(JmsMessageHeaderType.JMSReplyTo.toString(), SjmsExchangeMessageHelper.getJMSReplyTo(jmsMessage));
                headers.put(JmsMessageHeaderType.JMSType.toString(), SjmsExchangeMessageHelper.getJMSType(jmsMessage));
                headers.put(JmsMessageHeaderType.JMSXGroupID.toString(), jmsMessage.getStringProperty(JmsMessageHeaderType.JMSXGroupID.toString()));
            }
            catch (JMSException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
            Enumeration enumeration = jmsMessage.getPropertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (SjmsExchangeMessageHelper.hasIllegalHeaderKey(key)) {
                    throw new IllegalHeaderException("Header " + key + " is not a legal JMS header name value");
                }
                Object value = jmsMessage.getObjectProperty(key);
                headers.put(key, value);
            }
        }
        if (out) {
            exchange.getOut().setHeaders(headers);
        } else {
            exchange.getIn().setHeaders(headers);
        }
        return exchange;
    }

    public static Message createMessage(Exchange exchange, Session session, KeyFormatStrategy keyFormatStrategy) throws Exception {
        Message answer = null;
        Object body = null;
        HashMap<String, Object> bodyHeaders = null;
        if (exchange.getOut().getBody() != null) {
            body = exchange.getOut().getBody();
            bodyHeaders = new HashMap<String, Object>(exchange.getOut().getHeaders());
        } else {
            body = exchange.getIn().getBody();
            bodyHeaders = new HashMap(exchange.getIn().getHeaders());
        }
        answer = JmsMessageHelper.createMessage(session, body, bodyHeaders, keyFormatStrategy);
        return answer;
    }

    private static boolean hasIllegalHeaderKey(String key) {
        if (key == null) {
            return true;
        }
        if (key.equals("")) {
            return true;
        }
        if (key.indexOf(".") > -1) {
            return true;
        }
        return key.indexOf("-") > -1;
    }
}

