/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.consumer;

import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.consumer.AbstractMessageHandler;
import org.apache.camel.spi.Synchronization;

public class InOnlyMessageHandler
extends AbstractMessageHandler {
    public InOnlyMessageHandler(Endpoint endpoint, ExecutorService executor) {
        super(endpoint, executor);
    }

    public InOnlyMessageHandler(Endpoint endpoint, ExecutorService executor, Synchronization synchronization) {
        super(endpoint, executor, synchronization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Exchange exchange) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling InOnly Message: {}", exchange.getIn().getBody());
        }
        if (exchange.isFailed()) {
            return;
        }
        NoOpAsyncCallback callback = new NoOpAsyncCallback();
        if (this.isTransacted() || this.isSynchronous()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Synchronous processing: Message[{}], Destination[{}] ", exchange.getIn().getBody(), (Object)this.getEndpoint().getEndpointUri());
            }
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            finally {
                callback.done(true);
            }
        } else {
            this.log.debug("Aynchronous processing: Message[{}], Destination[{}] ", exchange.getIn().getBody(), (Object)this.getEndpoint().getEndpointUri());
            this.getProcessor().process(exchange, (AsyncCallback)callback);
        }
    }

    @Override
    public void close() {
    }

    protected class NoOpAsyncCallback
    implements AsyncCallback {
        public void done(boolean sync) {
            InOnlyMessageHandler.this.log.debug("NoOpAsyncCallback InOnly Exchange complete");
        }
    }
}

