/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.camel.util.ObjectHelper;

public final class JmsObjectFactory {
    private JmsObjectFactory() {
    }

    public static Destination createDestination(Session session, String destinationName, boolean topic) throws Exception {
        if (topic) {
            return JmsObjectFactory.createTopic(session, destinationName);
        }
        return JmsObjectFactory.createQueue(session, destinationName);
    }

    public static Destination createQueue(Session session, String destinationName) throws Exception {
        return session.createQueue(destinationName);
    }

    public static Destination createTemporaryDestination(Session session, boolean topic) throws Exception {
        if (topic) {
            return session.createTemporaryTopic();
        }
        return session.createTemporaryQueue();
    }

    public static Destination createTopic(Session session, String destinationName) throws Exception {
        return session.createTopic(destinationName);
    }

    public static MessageConsumer createQueueConsumer(Session session, String destinationName) throws Exception {
        return JmsObjectFactory.createMessageConsumer(session, destinationName, null, false, null, true);
    }

    public static MessageConsumer createQueueConsumer(Session session, String destinationName, String messageSelector) throws Exception {
        return JmsObjectFactory.createMessageConsumer(session, destinationName, messageSelector, false, null, true);
    }

    public static MessageConsumer createTopicConsumer(Session session, String destinationName, String messageSelector) throws Exception {
        return JmsObjectFactory.createMessageConsumer(session, destinationName, messageSelector, true, null, true);
    }

    public static MessageConsumer createTemporaryMessageConsumer(Session session, String messageSelector, boolean topic, String durableSubscriptionId, boolean noLocal) throws Exception {
        Destination destination = JmsObjectFactory.createTemporaryDestination(session, topic);
        return JmsObjectFactory.createMessageConsumer(session, destination, messageSelector, topic, durableSubscriptionId, noLocal);
    }

    public static MessageConsumer createMessageConsumer(Session session, String destinationName, String messageSelector, boolean topic, String durableSubscriptionId) throws Exception {
        return JmsObjectFactory.createMessageConsumer(session, destinationName, messageSelector, topic, durableSubscriptionId, true);
    }

    public static MessageConsumer createMessageConsumer(Session session, String destinationName, String messageSelector, boolean topic, String durableSubscriptionId, boolean noLocal) throws Exception {
        Object destination = null;
        destination = topic ? session.createTopic(destinationName) : session.createQueue(destinationName);
        return JmsObjectFactory.createMessageConsumer(session, (Destination)destination, messageSelector, topic, durableSubscriptionId, noLocal);
    }

    public static MessageConsumer createMessageConsumer(Session session, Destination destination, String messageSelector, boolean topic, String durableSubscriptionId, boolean noLocal) throws Exception {
        Object messageConsumer = null;
        messageConsumer = topic ? (ObjectHelper.isNotEmpty((Object)durableSubscriptionId) ? (ObjectHelper.isNotEmpty((Object)messageSelector) ? session.createDurableSubscriber((Topic)destination, durableSubscriptionId, messageSelector, noLocal) : session.createDurableSubscriber((Topic)destination, durableSubscriptionId)) : (ObjectHelper.isNotEmpty((Object)messageSelector) ? session.createConsumer((Destination)((Topic)destination), messageSelector, noLocal) : session.createConsumer((Destination)((Topic)destination)))) : (ObjectHelper.isNotEmpty((Object)messageSelector) ? session.createConsumer(destination, messageSelector) : session.createConsumer(destination));
        return messageConsumer;
    }

    public static MessageProducer createQueueProducer(Session session, String destinationName) throws Exception {
        return JmsObjectFactory.createMessageProducer(session, destinationName, false, true, -1L);
    }

    public static MessageProducer createTopicProducer(Session session, String destinationName) throws Exception {
        return JmsObjectFactory.createMessageProducer(session, destinationName, true, false, -1L);
    }

    public static MessageProducer createMessageProducer(Session session, String destinationName, boolean topic, boolean persitent, long ttl) throws Exception {
        MessageProducer messageProducer = null;
        Topic destination = null;
        if (topic) {
            if (destinationName.startsWith("topic://")) {
                destinationName = destinationName.substring("topic://".length());
            }
            destination = session.createTopic(destinationName);
        } else {
            if (destinationName.startsWith("queue://")) {
                destinationName = destinationName.substring("queue://".length());
            }
            destination = session.createQueue(destinationName);
        }
        messageProducer = session.createProducer((Destination)destination);
        if (persitent) {
            messageProducer.setDeliveryMode(2);
        } else {
            messageProducer.setDeliveryMode(1);
        }
        if (ttl > 0L) {
            messageProducer.setTimeToLive(ttl);
        }
        return messageProducer;
    }
}

