/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.producer;

import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsExchangeMessageHelper;
import org.apache.camel.component.sjms.SjmsProducer;
import org.apache.camel.component.sjms.jms.JmsObjectFactory;
import org.apache.camel.component.sjms.jms.ObjectPool;
import org.apache.camel.component.sjms.tx.SessionTransactionSynchronization;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InOutProducer
extends SjmsProducer {
    private static Map<String, Exchanger<Object>> exchangerMap = new TreeMap<String, Exchanger<Object>>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private MessageConsumerPool consumers;

    public InOutProducer(SjmsEndpoint endpoint) {
        super((Endpoint)endpoint);
        endpoint.getConsumerCount();
    }

    @Override
    protected void doStart() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.getNamedReplyTo())) {
            this.log.debug("No reply to destination is defined.  Using temporary destinations.");
        } else {
            this.log.debug("Using {} as the reply to destination.", (Object)this.getNamedReplyTo());
        }
        if (this.getConsumers() == null) {
            this.setConsumers(new MessageConsumerPool(this.getConsumerCount()));
            this.getConsumers().fillPool();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.getConsumers() != null) {
            this.getConsumers().drainPool();
            this.setConsumers(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SjmsProducer.MessageProducerResources doCreateProducerModel() throws Exception {
        SjmsProducer.MessageProducerResources answer = null;
        Connection conn = null;
        try {
            MessageProducer messageProducer = null;
            Session session = null;
            conn = this.getConnectionResource().borrowConnection();
            session = this.isEndpointTransacted() ? conn.createSession(true, this.getAcknowledgeMode()) : conn.createSession(false, this.getAcknowledgeMode());
            messageProducer = JmsObjectFactory.createMessageProducer(session, this.getDestinationName(), this.isTopic(), this.isPersistent(), this.getTtl());
            if (session == null) {
                throw new CamelException("Message Consumer Creation Exception: Session is NULL");
            }
            if (messageProducer == null) {
                throw new CamelException("Message Consumer Creation Exception: MessageProducer is NULL");
            }
            answer = new SjmsProducer.MessageProducerResources(session, messageProducer);
        }
        catch (Exception e) {
            this.log.error("Unable to create the MessageProducer: " + e.getLocalizedMessage());
        }
        finally {
            if (conn != null) {
                this.getConnectionResource().returnConnection(conn);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Exchange exchange, AsyncCallback callback) throws Exception {
        if (this.getProducers() != null) {
            SjmsProducer.MessageProducerResources producer = null;
            try {
                producer = (SjmsProducer.MessageProducerResources)this.getProducers().borrowObject(this.getResponseTimeOut());
            }
            catch (Exception e1) {
                this.log.warn("The producer pool is exhausted.  Consider setting producerCount to a higher value or disable the fixed size of the pool by setting fixedResourcePool=false.");
                exchange.setException((Throwable)new Exception("Producer Resource Pool is exhausted"));
            }
            if (producer != null) {
                if (this.isEndpointTransacted()) {
                    exchange.getUnitOfWork().addSynchronization((Synchronization)new SessionTransactionSynchronization(producer.getSession(), this.getCommitStrategy()));
                }
                Message request = SjmsExchangeMessageHelper.createMessage(exchange, producer.getSession(), this.getSjmsEndpoint().getJmsKeyFormatStrategy());
                String correlationId = null;
                correlationId = exchange.getIn().getHeader("JMSCorrelationID", String.class) == null ? UUID.randomUUID().toString().replace("-", "") : (String)exchange.getIn().getHeader("JMSCorrelationID", String.class);
                Object responseObject = null;
                Exchanger<Object> messageExchanger = new Exchanger<Object>();
                SjmsExchangeMessageHelper.setCorrelationId(request, correlationId);
                try {
                    this.lock.writeLock().lock();
                    exchangerMap.put(correlationId, messageExchanger);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                MessageConsumerResource consumer = (MessageConsumerResource)this.consumers.borrowObject(this.getResponseTimeOut());
                SjmsExchangeMessageHelper.setJMSReplyTo(request, consumer.getReplyToDestination());
                this.consumers.returnObject(consumer);
                producer.getMessageProducer().send(request);
                try {
                    this.getProducers().returnObject(producer);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    responseObject = messageExchanger.exchange(null, this.getResponseTimeOut(), TimeUnit.MILLISECONDS);
                    try {
                        this.lock.writeLock().lock();
                        exchangerMap.remove(correlationId);
                    }
                    finally {
                        this.lock.writeLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    this.log.debug("Exchanger was interrupted while waiting on response", (Throwable)e);
                    exchange.setException((Throwable)e);
                }
                catch (TimeoutException e) {
                    this.log.debug("Exchanger timed out while waiting on response", (Throwable)e);
                    exchange.setException((Throwable)e);
                }
                if (exchange.getException() == null) {
                    if (responseObject instanceof Throwable) {
                        exchange.setException((Throwable)responseObject);
                    } else if (responseObject instanceof Message) {
                        Message response = responseObject;
                        SjmsExchangeMessageHelper.populateExchange(response, exchange, true);
                    } else {
                        exchange.setException((Throwable)new CamelException("Unknown response type: " + responseObject));
                    }
                }
            }
            callback.done(this.isSynchronous());
        }
    }

    public void setConsumers(MessageConsumerPool consumers) {
        this.consumers = consumers;
    }

    public MessageConsumerPool getConsumers() {
        return this.consumers;
    }

    protected class InternalTempDestinationListener
    implements MessageListener {
        private final Logger tempLogger = LoggerFactory.getLogger(InternalTempDestinationListener.class);
        private Exchanger<Object> exchanger;

        public InternalTempDestinationListener(Exchanger<Object> exchanger) {
            this.exchanger = exchanger;
        }

        public void onMessage(Message message) {
            if (this.tempLogger.isDebugEnabled()) {
                this.tempLogger.debug("Message Received in the Consumer Pool");
                this.tempLogger.debug("  Message : {}", (Object)message);
            }
            try {
                this.exchanger.exchange(message, InOutProducer.this.getResponseTimeOut(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    protected class MessageConsumerResource {
        private final Session session;
        private final MessageConsumer messageConsumer;
        private final Destination replyToDestination;

        public MessageConsumerResource(Session session, MessageConsumer messageConsumer, Destination replyToDestination) {
            this.session = session;
            this.messageConsumer = messageConsumer;
            this.replyToDestination = replyToDestination;
        }

        public Session getSession() {
            return this.session;
        }

        public MessageConsumer getMessageConsumer() {
            return this.messageConsumer;
        }

        public Destination getReplyToDestination() {
            return this.replyToDestination;
        }
    }

    protected class MessageConsumerPool
    extends ObjectPool<MessageConsumerResource> {
        public MessageConsumerPool(int poolSize) {
            super(poolSize);
        }

        @Override
        protected MessageConsumerResource createObject() throws Exception {
            MessageConsumerResource answer = null;
            Connection conn = null;
            Session session = null;
            try {
                conn = InOutProducer.this.getConnectionResource().borrowConnection();
                session = InOutProducer.this.isEndpointTransacted() ? conn.createSession(true, 0) : conn.createSession(false, 1);
                Destination replyToDestination = null;
                replyToDestination = ObjectHelper.isEmpty((Object)InOutProducer.this.getNamedReplyTo()) ? JmsObjectFactory.createTemporaryDestination(session, InOutProducer.this.isTopic()) : JmsObjectFactory.createDestination(session, InOutProducer.this.getNamedReplyTo(), InOutProducer.this.isTopic());
                MessageConsumer messageConsumer = JmsObjectFactory.createMessageConsumer(session, replyToDestination, null, InOutProducer.this.isTopic(), null, true);
                messageConsumer.setMessageListener(new MessageListener(){

                    public void onMessage(Message message) {
                        if (MessageConsumerPool.this.logger.isDebugEnabled()) {
                            MessageConsumerPool.this.logger.debug("Message Received in the Consumer Pool");
                            MessageConsumerPool.this.logger.debug("  Message : {}", (Object)message);
                        }
                        try {
                            Exchanger exchanger = (Exchanger)exchangerMap.get(message.getJMSCorrelationID());
                            exchanger.exchange(message, InOutProducer.this.getResponseTimeOut(), TimeUnit.MILLISECONDS);
                        }
                        catch (Exception e) {
                            ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                        }
                    }
                });
                answer = new MessageConsumerResource(session, messageConsumer, replyToDestination);
            }
            catch (Exception e) {
                InOutProducer.this.log.error("Unable to create the MessageConsumerResource: " + e.getLocalizedMessage());
                throw new CamelException((Throwable)e);
            }
            finally {
                InOutProducer.this.getConnectionResource().returnConnection(conn);
            }
            return answer;
        }

        @Override
        protected void destroyObject(MessageConsumerResource model) throws Exception {
            if (model.getMessageConsumer() != null) {
                model.getMessageConsumer().close();
            }
            if (model.getSession() != null) {
                if (model.getSession().getTransacted()) {
                    try {
                        model.getSession().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                model.getSession().close();
            }
        }
    }
}

